/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.BatchJob;
import com.google.genai.types.CachedContent;
import com.google.genai.types.File;
import com.google.genai.types.ListBatchJobsConfig;
import com.google.genai.types.ListCachedContentsConfig;
import com.google.genai.types.ListFilesConfig;
import com.google.genai.types.ListModelsConfig;
import com.google.genai.types.ListTuningJobsConfig;
import com.google.genai.types.Model;
import com.google.genai.types.TuningJob;
import java.util.ArrayList;

abstract class BasePager<T extends JsonSerializable> {
    protected final PagedItem pagedItem;
    protected final ObjectNode requestConfig;
    protected ImmutableList<T> page;
    protected int pageSize;
    protected String nextPageToken;

    protected BasePager(PagedItem pagedItem, ObjectNode requestConfig) {
        if (pagedItem == null) {
            throw new IllegalArgumentException("PagedItem cannot be null.");
        }
        if (requestConfig == null) {
            throw new IllegalArgumentException("Initial request config cannot be null.");
        }
        this.pagedItem = pagedItem;
        this.requestConfig = requestConfig.deepCopy();
    }

    protected void initNewPage(JsonNode response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null.");
        }
        JsonNode responseList = response.get(this.pagedItem.fieldName());
        if (responseList == null) {
            throw new GenAiIOException("Response does not contain the requested item. Raw response: " + JsonSerializable.toJsonString(response));
        }
        ArrayList<JsonSerializable> page = new ArrayList<JsonSerializable>();
        for (JsonNode responseItem : responseList) {
            page.add(JsonSerializable.fromJsonNode(responseItem, this.pagedItem.itemClass()));
        }
        this.page = ImmutableList.copyOf(page);
        this.pageSize = this.requestConfig.get("pageSize") != null ? this.requestConfig.get("pageSize").intValue() : this.page.size();
        if (response.get("nextPageToken") != null) {
            this.requestConfig.put("pageToken", response.get("nextPageToken").asText());
        } else {
            this.requestConfig.remove("pageToken");
        }
    }

    static enum PagedItem {
        MODELS("models", Model.class, ListModelsConfig.class),
        CACHED_CONTENTS("cachedContents", CachedContent.class, ListCachedContentsConfig.class),
        FILES("files", File.class, ListFilesConfig.class),
        BATCH_JOBS("batchJobs", BatchJob.class, ListBatchJobsConfig.class),
        TUNING_JOBS("tuningJobs", TuningJob.class, ListTuningJobsConfig.class);

        private final String fieldName;
        private final Class<? extends JsonSerializable> itemClass;
        private final Class<? extends JsonSerializable> requestConfigClass;

        private PagedItem(String fieldName, Class<? extends JsonSerializable> itemClass, Class<? extends JsonSerializable> requestConfigClass) {
            this.fieldName = fieldName;
            this.itemClass = itemClass;
            this.requestConfigClass = requestConfigClass;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Class<? extends JsonSerializable> itemClass() {
            return this.itemClass;
        }

        public Class<? extends JsonSerializable> requestConfigClass() {
            return this.requestConfigClass;
        }
    }
}

