/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.AdapterSize;
import com.google.genai.types.DistillationHyperParameters;
import java.util.Optional;

final class AutoValue_DistillationHyperParameters
extends DistillationHyperParameters {
    private final Optional<AdapterSize> adapterSize;
    private final Optional<Long> epochCount;
    private final Optional<Double> learningRateMultiplier;

    private AutoValue_DistillationHyperParameters(Optional<AdapterSize> adapterSize, Optional<Long> epochCount, Optional<Double> learningRateMultiplier) {
        this.adapterSize = adapterSize;
        this.epochCount = epochCount;
        this.learningRateMultiplier = learningRateMultiplier;
    }

    @Override
    @JsonProperty(value="adapterSize")
    public Optional<AdapterSize> adapterSize() {
        return this.adapterSize;
    }

    @Override
    @JsonProperty(value="epochCount")
    public Optional<Long> epochCount() {
        return this.epochCount;
    }

    @Override
    @JsonProperty(value="learningRateMultiplier")
    public Optional<Double> learningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public String toString() {
        return "DistillationHyperParameters{adapterSize=" + this.adapterSize + ", epochCount=" + this.epochCount + ", learningRateMultiplier=" + this.learningRateMultiplier + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DistillationHyperParameters) {
            DistillationHyperParameters that = (DistillationHyperParameters)o;
            return this.adapterSize.equals(that.adapterSize()) && this.epochCount.equals(that.epochCount()) && this.learningRateMultiplier.equals(that.learningRateMultiplier());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.adapterSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.epochCount.hashCode();
        h$ *= 1000003;
        return h$ ^= this.learningRateMultiplier.hashCode();
    }

    @Override
    public DistillationHyperParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DistillationHyperParameters.Builder {
        private Optional<AdapterSize> adapterSize = Optional.empty();
        private Optional<Long> epochCount = Optional.empty();
        private Optional<Double> learningRateMultiplier = Optional.empty();

        Builder() {
        }

        Builder(DistillationHyperParameters source) {
            this.adapterSize = source.adapterSize();
            this.epochCount = source.epochCount();
            this.learningRateMultiplier = source.learningRateMultiplier();
        }

        @Override
        public DistillationHyperParameters.Builder adapterSize(AdapterSize adapterSize) {
            this.adapterSize = Optional.of(adapterSize);
            return this;
        }

        @Override
        public DistillationHyperParameters.Builder epochCount(Long epochCount) {
            this.epochCount = Optional.of(epochCount);
            return this;
        }

        @Override
        public DistillationHyperParameters.Builder learningRateMultiplier(Double learningRateMultiplier) {
            this.learningRateMultiplier = Optional.of(learningRateMultiplier);
            return this;
        }

        @Override
        public DistillationHyperParameters build() {
            return new AutoValue_DistillationHyperParameters(this.adapterSize, this.epochCount, this.learningRateMultiplier);
        }
    }
}

