/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.testing.GuavaAsserts;
import com.google.common.testing.RelationshipTester;
import java.util.List;

@Beta
@GwtCompatible
public final class EqualsTester {
    private static final int REPETITIONS = 3;
    private final List<List<Object>> equalityGroups = Lists.newArrayList();

    public EqualsTester addEqualityGroup(Object ... equalityGroup) {
        Preconditions.checkNotNull((Object)equalityGroup);
        this.equalityGroups.add((List<Object>)ImmutableList.copyOf((Object[])equalityGroup));
        return this;
    }

    public EqualsTester testEquals() {
        RelationshipTester<Object> delegate = new RelationshipTester<Object>(new RelationshipTester.RelationshipAssertion<Object>(){

            @Override
            public void assertRelated(Object item, Object related) {
                GuavaAsserts.assertEquals("$ITEM must be equal to $RELATED", item, related);
                int itemHash = item.hashCode();
                int relatedHash = related.hashCode();
                GuavaAsserts.assertEquals("the hash (" + itemHash + ") of $ITEM must be equal to the hash (" + relatedHash + ") of $RELATED", itemHash, relatedHash);
            }

            @Override
            public void assertUnrelated(Object item, Object unrelated) {
                GuavaAsserts.assertTrue("$ITEM must be unequal to $UNRELATED", !Objects.equal((Object)item, (Object)unrelated));
            }
        });
        for (List<Object> group : this.equalityGroups) {
            delegate.addRelatedGroup(group);
        }
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (Object item : Iterables.concat(this.equalityGroups)) {
            GuavaAsserts.assertTrue(item + " must be unequal to null", !item.equals(null));
            GuavaAsserts.assertTrue(item + " must be unequal to an arbitrary object of another class", !item.equals((Object)NotAnInstance.EQUAL_TO_NOTHING));
            GuavaAsserts.assertEquals(item + " must be equal to itself", item, item);
            GuavaAsserts.assertEquals("the hash of " + item + " must be consistent", item.hashCode(), item.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotAnInstance {
        EQUAL_TO_NOTHING;

    }
}

