/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.GuavaAsserts;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class RelationshipTester<T> {
    private final List<ImmutableList<T>> groups = Lists.newArrayList();
    private final RelationshipAssertion<T> assertion;

    RelationshipTester(RelationshipAssertion<T> assertion) {
        this.assertion = (RelationshipAssertion)Preconditions.checkNotNull(assertion);
    }

    public RelationshipTester<T> addRelatedGroup(Iterable<? extends T> group) {
        this.groups.add(ImmutableList.copyOf(group));
        return this;
    }

    public void test() {
        for (int groupNumber = 0; groupNumber < this.groups.size(); ++groupNumber) {
            ImmutableList<T> group = this.groups.get(groupNumber);
            for (int itemNumber = 0; itemNumber < group.size(); ++itemNumber) {
                for (int relatedItemNumber = 0; relatedItemNumber < group.size(); ++relatedItemNumber) {
                    if (itemNumber == relatedItemNumber) continue;
                    this.assertRelated(groupNumber, itemNumber, relatedItemNumber);
                }
                for (int unrelatedGroupNumber = 0; unrelatedGroupNumber < this.groups.size(); ++unrelatedGroupNumber) {
                    if (groupNumber == unrelatedGroupNumber) continue;
                    ImmutableList<T> unrelatedGroup = this.groups.get(unrelatedGroupNumber);
                    for (int unrelatedItemNumber = 0; unrelatedItemNumber < unrelatedGroup.size(); ++unrelatedItemNumber) {
                        this.assertUnrelated(groupNumber, itemNumber, unrelatedGroupNumber, unrelatedItemNumber);
                    }
                }
            }
        }
    }

    private void assertRelated(int groupNumber, int itemNumber, int relatedItemNumber) {
        ImmutableList<T> group = this.groups.get(groupNumber);
        Object item = group.get(itemNumber);
        Object related = group.get(relatedItemNumber);
        try {
            this.assertion.assertRelated(item, related);
        }
        catch (GuavaAsserts.TestAssertionFailure e) {
            throw new GuavaAsserts.TestAssertionFailure(e.getMessage().replace("$ITEM", RelationshipTester.itemString(item, groupNumber, itemNumber)).replace("$RELATED", RelationshipTester.itemString(related, groupNumber, relatedItemNumber)));
        }
    }

    private void assertUnrelated(int groupNumber, int itemNumber, int unrelatedGroupNumber, int unrelatedItemNumber) {
        Object item = this.groups.get(groupNumber).get(itemNumber);
        Object unrelated = this.groups.get(unrelatedGroupNumber).get(unrelatedItemNumber);
        try {
            this.assertion.assertUnrelated(item, unrelated);
        }
        catch (GuavaAsserts.TestAssertionFailure e) {
            throw new GuavaAsserts.TestAssertionFailure(e.getMessage().replace("$ITEM", RelationshipTester.itemString(item, groupNumber, itemNumber)).replace("$UNRELATED", RelationshipTester.itemString(unrelated, unrelatedGroupNumber, unrelatedItemNumber)));
        }
    }

    private static String itemString(Object item, int groupNumber, int itemNumber) {
        return item + " [group " + (groupNumber + 1) + ", item " + (itemNumber + 1) + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RelationshipAssertion<T> {
        public void assertRelated(T var1, T var2);

        public void assertUnrelated(T var1, T var2);
    }
}

