/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.TesterAnnotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CollectionSize implements Feature<Collection>,
Comparable<CollectionSize>
{
    ZERO(0),
    ONE(1),
    SEVERAL(3),
    ANY(ZERO, ONE, SEVERAL);

    private final Set<Feature<? super Collection>> implied;
    private final Integer numElements;

    private CollectionSize(int numElements) {
        this.implied = Collections.emptySet();
        this.numElements = numElements;
    }

    private CollectionSize(Feature<? super Collection> ... implied) {
        this.implied = Helpers.copyToSet(implied);
        this.numElements = null;
    }

    @Override
    public Set<Feature<? super Collection>> getImpliedFeatures() {
        return this.implied;
    }

    public int getNumElements() {
        if (this.numElements == null) {
            throw new IllegalStateException("A compound CollectionSize doesn't specify a number of elements.");
        }
        return this.numElements;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @TesterAnnotation
    public static @interface Require {
        public CollectionSize[] value() default {};

        public CollectionSize[] absent() default {};
    }
}

