/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.collect.testing.google.Platform;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class MultisetIteratorTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.KNOWN_ORDER})
    public void testRemovingIteratorKnownOrder() {
        new IteratorTester<E>(4, IteratorFeature.MODIFIABLE, ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).order(Arrays.asList(this.samples.e0, this.samples.e1, this.samples.e1, this.samples.e2)), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            @Override
            protected Iterator<E> newTargetIterator() {
                return ((Collection)((OneSizeTestContainerGenerator)MultisetIteratorTester.this.getSubjectGenerator()).create(((MultisetIteratorTester)MultisetIteratorTester.this).samples.e0, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e2)).iterator();
            }
        }.test();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.KNOWN_ORDER})
    public void testRemovingIteratorUnknownOrder() {
        new IteratorTester<E>(4, IteratorFeature.MODIFIABLE, Arrays.asList(this.samples.e0, this.samples.e1, this.samples.e1, this.samples.e2), AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER){

            @Override
            protected Iterator<E> newTargetIterator() {
                return ((Collection)((OneSizeTestContainerGenerator)MultisetIteratorTester.this.getSubjectGenerator()).create(((MultisetIteratorTester)MultisetIteratorTester.this).samples.e0, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e2)).iterator();
            }
        }.test();
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER}, absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testIteratorKnownOrder() {
        new IteratorTester<E>(4, IteratorFeature.UNMODIFIABLE, ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).order(Arrays.asList(this.samples.e0, this.samples.e1, this.samples.e1, this.samples.e2)), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            @Override
            protected Iterator<E> newTargetIterator() {
                return ((Collection)((OneSizeTestContainerGenerator)MultisetIteratorTester.this.getSubjectGenerator()).create(((MultisetIteratorTester)MultisetIteratorTester.this).samples.e0, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e2)).iterator();
            }
        }.test();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.KNOWN_ORDER})
    public void testIteratorUnknownOrder() {
        new IteratorTester<E>(4, IteratorFeature.UNMODIFIABLE, Arrays.asList(this.samples.e0, this.samples.e1, this.samples.e1, this.samples.e2), AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER){

            @Override
            protected Iterator<E> newTargetIterator() {
                return ((Collection)((OneSizeTestContainerGenerator)MultisetIteratorTester.this.getSubjectGenerator()).create(((MultisetIteratorTester)MultisetIteratorTester.this).samples.e0, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e1, ((MultisetIteratorTester)MultisetIteratorTester.this).samples.e2)).iterator();
            }
        }.test();
    }

    public static List<Method> getIteratorDuplicateInitializingMethods() {
        return Arrays.asList(Platform.getMethod(MultisetIteratorTester.class, "testIteratorKnownOrder"), Platform.getMethod(MultisetIteratorTester.class, "testIteratorUnknownOrder"), Platform.getMethod(MultisetIteratorTester.class, "testRemovingIteratorKnownOrder"), Platform.getMethod(MultisetIteratorTester.class, "testRemovingIteratorUnknownOrder"));
    }
}

