/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRetainAllTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_RETAIN_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_duplicatesKept() {
        Object[] array = this.createSamplesArray();
        array[1] = this.samples.e0;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        ListRetainAllTester.assertFalse((String)"containsDuplicates.retainAll(superset) should return false", (boolean)this.collection.retainAll(MinimalCollection.of(this.createSamplesArray())));
        this.expectContents(array);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_RETAIN_ALL})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRetainAll_duplicatesRemoved() {
        Object[] array = this.createSamplesArray();
        array[1] = this.samples.e0;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        ListRetainAllTester.assertTrue((String)"containsDuplicates.retainAll(subset) should return true", (boolean)this.collection.retainAll(MinimalCollection.of(this.samples.e2)));
        this.expectContents(this.samples.e2);
    }
}

