/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.testing.GuavaAsserts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class SerializableTester {
    private SerializableTester() {
    }

    public static <T> T reserialize(T object) {
        Preconditions.checkNotNull(object);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(object);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T reserializeAndAssert(T object) {
        T copy = SerializableTester.reserialize(object);
        GuavaAsserts.checkEqualsAndHashCodeMethods("Equals/Hashcode mismatch.  original=" + object + ", copy=" + copy, object, copy, true);
        GuavaAsserts.assertEquals(object.getClass(), copy.getClass());
        return copy;
    }
}

