/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.GuavaAsserts;
import com.google.common.testing.RelationshipTester;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class EquivalenceTester<T> {
    private static final int REPETITIONS = 3;
    private final Equivalence<? super T> equivalence;
    private final RelationshipTester<T> delegate;
    private final List<T> items = Lists.newArrayList();

    EquivalenceTester(final Equivalence<? super T> equivalence) {
        this.equivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.delegate = new RelationshipTester(new RelationshipTester.RelationshipAssertion<T>(){

            @Override
            public void assertRelated(T item, T related) {
                GuavaAsserts.assertTrue("$ITEM must be equivalent to $RELATED", equivalence.equivalent(item, related));
                int itemHash = equivalence.hash(item);
                int relatedHash = equivalence.hash(related);
                GuavaAsserts.assertEquals("the hash (" + itemHash + ") of $ITEM must be equal to the hash (" + relatedHash + ") of $RELATED", itemHash, relatedHash);
            }

            @Override
            public void assertUnrelated(T item, T unrelated) {
                GuavaAsserts.assertTrue("$ITEM must be inequivalent to $UNRELATED", !equivalence.equivalent(item, unrelated));
            }
        });
    }

    public static <T> EquivalenceTester<T> of(Equivalence<? super T> equivalence) {
        return new EquivalenceTester<T>(equivalence);
    }

    public EquivalenceTester<T> addEquivalenceGroup(T first, T ... rest) {
        this.addEquivalenceGroup(Lists.asList(first, (Object[])rest));
        return this;
    }

    public EquivalenceTester<T> addEquivalenceGroup(Iterable<T> group) {
        this.delegate.addRelatedGroup(group);
        this.items.addAll((Collection<T>)ImmutableList.copyOf(group));
        return this;
    }

    public EquivalenceTester<T> test() {
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            this.delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (T item : this.items) {
            GuavaAsserts.assertTrue(item + " must be inequivalent to null", !this.equivalence.equivalent(item, null));
            GuavaAsserts.assertTrue("null must be inequivalent to " + item, !this.equivalence.equivalent(null, item));
            GuavaAsserts.assertTrue(item + " must be equivalent to itself", this.equivalence.equivalent(item, item));
            GuavaAsserts.assertEquals("the hash of " + item + " must be consistent", this.equivalence.hash(item), this.equivalence.hash(item));
        }
    }
}

