/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;

@Beta
@GwtCompatible
public final class GuavaAsserts {
    private GuavaAsserts() {
    }

    public static void checkEqualsAndHashCodeMethods(String message, Object lhs, Object rhs, boolean expectedResult) {
        if (lhs == null && rhs == null) {
            GuavaAsserts.assertTrue("Your check is dubious...why would you expect null != null?", expectedResult);
            return;
        }
        if (lhs == null || rhs == null) {
            GuavaAsserts.assertTrue("Your check is dubious...why would you expect an object to be equal to null?", !expectedResult);
        }
        if (lhs != null) {
            GuavaAsserts.assertEqualsImpl(message, expectedResult, lhs.equals(rhs));
        }
        if (rhs != null) {
            GuavaAsserts.assertEqualsImpl(message, expectedResult, rhs.equals(lhs));
        }
        if (expectedResult) {
            String hashMessage = "hashCode() values for equal objects should be the same";
            if (message != null) {
                hashMessage = hashMessage + ": " + message;
            }
            GuavaAsserts.assertTrue(hashMessage, lhs.hashCode() == rhs.hashCode());
        }
    }

    private static void assertEqualsImpl(String message, Object expected, Object actual) {
        if (!Objects.equal((Object)expected, (Object)actual)) {
            GuavaAsserts.failWithMessage(message, "expected:<" + expected + "> but was:<" + actual + ">");
        }
    }

    private static void failWithMessage(String userMessage, String ourMessage) {
        GuavaAsserts.fail(userMessage == null ? ourMessage : userMessage + ' ' + ourMessage);
    }

    public static void fail() {
        throw new TestAssertionFailure();
    }

    public static void fail(String message) {
        throw new TestAssertionFailure(message);
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            GuavaAsserts.fail("Condition expected to be true but was false.");
        }
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            GuavaAsserts.fail(message);
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        GuavaAsserts.assertEquals("Expected '" + expected + "' but got '" + actual + "'", expected, actual);
    }

    public static void assertEquals(String message, Object o1, Object o2) {
        if (o1 == null) {
            GuavaAsserts.assertTrue(message, o2 == null);
            return;
        }
        GuavaAsserts.assertTrue(message, o1.equals(o2));
    }

    public static class TestAssertionFailure
    extends AssertionError {
        public TestAssertionFailure() {
        }

        public TestAssertionFailure(String errorMessage) {
            super((Object)errorMessage);
        }
    }
}

