/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public final class ListGenerators {
    private ListGenerators() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnhashableElementsImmutableListGenerator
    extends TestUnhashableListGenerator {
        @Override
        public List<UnhashableObject> create(UnhashableObject[] elements) {
            return ImmutableList.copyOf((Object[])elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TestUnhashableListGenerator
    extends TestUnhashableCollectionGenerator<List<UnhashableObject>>
    implements TestListGenerator<UnhashableObject> {
        private TestUnhashableListGenerator() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableListMiddleSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            String[] prefix = new String[]{"f", "g"};
            String[] suffix = new String[]{"h", "i"};
            Object[] all = new String[2 + elements.length + 2];
            System.arraycopy(prefix, 0, all, 0, 2);
            System.arraycopy(elements, 0, all, 2, elements.length);
            System.arraycopy(suffix, 0, all, 2 + elements.length, 2);
            return ImmutableList.copyOf((Object[])all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableListTailSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            String[] prefix = new String[]{"f", "g"};
            Object[] all = new String[elements.length + prefix.length];
            System.arraycopy(prefix, 0, all, 0, 2);
            System.arraycopy(elements, 0, all, 2, elements.length);
            return ImmutableList.copyOf((Object[])all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableListHeadSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            String[] suffix = new String[]{"f", "g"};
            Object[] all = new String[elements.length + suffix.length];
            System.arraycopy(elements, 0, all, 0, elements.length);
            System.arraycopy(suffix, 0, all, elements.length, suffix.length);
            return ImmutableList.copyOf((Object[])all).subList(0, elements.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuilderReversedListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            List<String> list = Arrays.asList(elements);
            Collections.reverse(list);
            return ImmutableList.copyOf(list).reverse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuilderAddAllListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            return ImmutableList.builder().addAll(Arrays.asList(elements)).build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuilderAddListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String element : elements) {
                builder.add((Object)element);
            }
            return builder.build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableListOfGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            return ImmutableList.copyOf((Object[])elements);
        }
    }
}

