/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestMapEntrySetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class SortedMapGenerators {
    public static final Comparator<Map.Entry<String, String>> ENTRY_COMPARATOR = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    private static String toStringOrNull(Object o) {
        return o == null ? null : o.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapEntrySetGenerator
    extends TestMapEntrySetGenerator<String, String> {
        public ImmutableSortedMapEntrySetGenerator() {
            super(new SampleElements.Strings(), new SampleElements.Strings());
        }

        @Override
        public Set<Map.Entry<String, String>> createFromEntries(Map.Entry<String, String>[] entries) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build().entrySet();
        }

        @Override
        public List<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
            Collections.sort(insertionOrder, ENTRY_COMPARATOR);
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapTailMapValuesGenerator
    implements TestCollectionGenerator<String> {
        @Override
        public SampleElements<String> samples() {
            return new SampleElements.Strings();
        }

        @Override
        public Collection<String> create(Object ... elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)-1, (Object)"begin");
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)SortedMapGenerators.toStringOrNull(elements[i]));
            }
            return builder.build().tailMap((Object)0).values();
        }

        public String[] createArray(int length) {
            return new String[length];
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapHeadMapKeySetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)"z", (Object)-1);
            for (String key : elements) {
                builder.put((Object)key, (Object)4);
            }
            return builder.build().headMap((Object)"z").keySet();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder);
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapSubMapEntryGenerator
    extends TestMapEntrySetGenerator<String, String> {
        public ImmutableSortedMapSubMapEntryGenerator() {
            super(new SampleElements.Strings(), new SampleElements.Strings());
        }

        @Override
        public Set<Map.Entry<String, String>> createFromEntries(Map.Entry<String, String>[] entries) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)"\u0000", (Object)"begin");
            builder.put((Object)"z", (Object)"end");
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build().subMap((Object)"a", (Object)"z").entrySet();
        }

        @Override
        public List<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
            Collections.sort(insertionOrder, ENTRY_COMPARATOR);
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapValuesGenerator
    implements TestCollectionGenerator<String> {
        @Override
        public SampleElements<String> samples() {
            return new SampleElements.Strings();
        }

        @Override
        public Collection<String> create(Object ... elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)SortedMapGenerators.toStringOrNull(elements[i]));
            }
            return builder.build().values();
        }

        public String[] createArray(int length) {
            return new String[length];
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedMapKeySetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (String key : elements) {
                builder.put((Object)key, (Object)4);
            }
            return builder.build().keySet();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder);
            return insertionOrder;
        }
    }
}

