/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class NullPointerTester {
    private final Map<Class<?>, Object> defaults = Maps.newHashMap();
    private final List<Member> ignoredMembers = Lists.newArrayList();

    public NullPointerTester() {
        this.setCommonDefaults();
    }

    private final void setCommonDefaults() {
        this.setDefault(Appendable.class, new StringBuilder());
        this.setDefault(CharSequence.class, "");
        this.setDefault(Class.class, Class.class);
        this.setDefault(Collection.class, Collections.emptySet());
        this.setDefault(Comparable.class, 0);
        this.setDefault(Comparator.class, Collections.reverseOrder());
        this.setDefault(Function.class, Functions.identity());
        this.setDefault(Integer.class, 0);
        this.setDefault(Iterable.class, Collections.emptySet());
        this.setDefault(Iterator.class, Iterators.emptyIterator());
        this.setDefault(List.class, Collections.emptyList());
        this.setDefault(Map.class, Collections.emptyMap());
        this.setDefault(Object.class, new Object());
        this.setDefault(Object[].class, new Object[0]);
        this.setDefault(Pattern.class, Pattern.compile(""));
        this.setDefault(Predicate.class, Predicates.alwaysTrue());
        this.setDefault(Set.class, Collections.emptySet());
        this.setDefault(SortedSet.class, new TreeSet());
        this.setDefault(String.class, "");
        this.setDefault(Supplier.class, Suppliers.ofInstance((Object)1));
        this.setDefault(Throwable.class, new Exception());
        this.setDefault(TimeUnit.class, TimeUnit.SECONDS);
        this.setDefault(Integer.TYPE, 0);
        this.setDefault(Long.TYPE, 0L);
        this.setDefault(Short.TYPE, (short)0);
        this.setDefault(Character.TYPE, Character.valueOf('a'));
        this.setDefault(Byte.TYPE, (byte)0);
        this.setDefault(Float.TYPE, Float.valueOf(0.0f));
        this.setDefault(Double.TYPE, 0.0);
        this.setDefault(Boolean.TYPE, false);
    }

    public <T> NullPointerTester setDefault(Class<T> type, T value) {
        this.defaults.put(type, value);
        return this;
    }

    public NullPointerTester ignore(Member member) {
        this.ignoredMembers.add(member);
        return this;
    }

    public void testAllPublicConstructors(Class<?> c) throws Exception {
        for (Constructor<?> constructor : c.getDeclaredConstructors()) {
            if (!NullPointerTester.isPublic(constructor) || NullPointerTester.isStatic(constructor) || this.isIgnored(constructor)) continue;
            this.testConstructor(constructor);
        }
    }

    public void testAllPublicStaticMethods(Class<?> c) throws Exception {
        for (Method method : c.getDeclaredMethods()) {
            if (!NullPointerTester.isPublic(method) || !NullPointerTester.isStatic(method) || this.isIgnored(method)) continue;
            this.testMethod(null, method);
        }
    }

    public void testAllPublicInstanceMethods(Object instance) throws Exception {
        Class<?> c = instance.getClass();
        for (Method method : c.getDeclaredMethods()) {
            if (!NullPointerTester.isPublic(method) || NullPointerTester.isStatic(method) || this.isIgnored(method)) continue;
            this.testMethod(instance, method);
        }
    }

    public void testMethod(Object instance, Method method) throws Exception {
        Class<?>[] types = method.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testMethodParameter(instance, method, nullIndex);
        }
    }

    public void testConstructor(Constructor<?> ctor) throws Exception {
        Class<?>[] types = ctor.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testConstructorParameter(ctor, nullIndex);
        }
    }

    public void testMethodParameter(Object instance, final Method method, int paramIndex) throws Exception {
        method.setAccessible(true);
        this.testFunctorParameter(instance, new Functor(){

            @Override
            public Class<?>[] getParameterTypes() {
                return method.getParameterTypes();
            }

            @Override
            public Annotation[][] getParameterAnnotations() {
                return method.getParameterAnnotations();
            }

            @Override
            public void invoke(Object instance, Object[] params) throws InvocationTargetException, IllegalAccessException {
                method.invoke(instance, params);
            }

            public String toString() {
                return method.getName() + "(" + Arrays.toString(this.getParameterTypes()) + ")";
            }
        }, paramIndex, method.getDeclaringClass());
    }

    public void testConstructorParameter(final Constructor<?> ctor, int paramIndex) throws Exception {
        ctor.setAccessible(true);
        this.testFunctorParameter(null, new Functor(){

            @Override
            public Class<?>[] getParameterTypes() {
                return ctor.getParameterTypes();
            }

            @Override
            public Annotation[][] getParameterAnnotations() {
                return ctor.getParameterAnnotations();
            }

            @Override
            public void invoke(Object instance, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                ctor.newInstance(params);
            }
        }, paramIndex, ctor.getDeclaringClass());
    }

    private void testFunctorParameter(Object instance, Functor func, int paramIndex, Class<?> testedClass) throws Exception {
        if (NullPointerTester.parameterIsPrimitiveOrNullable(func, paramIndex)) {
            return;
        }
        Object[] params = this.buildParamList(func, paramIndex);
        try {
            func.invoke(instance, params);
            Assert.fail((String)("No exception thrown from " + func + Arrays.toString(params) + " for " + testedClass));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NullPointerException || cause instanceof UnsupportedOperationException) {
                return;
            }
            AssertionFailedError error = new AssertionFailedError("wrong exception thrown from " + func + ": " + cause);
            error.initCause(cause);
            throw error;
        }
    }

    private static boolean parameterIsPrimitiveOrNullable(Functor func, int paramIndex) {
        Annotation[] annotations;
        if (func.getParameterTypes()[paramIndex].isPrimitive()) {
            return true;
        }
        for (Annotation annotation : annotations = func.getParameterAnnotations()[paramIndex]) {
            if (!(annotation instanceof Nullable)) continue;
            return true;
        }
        return false;
    }

    private Object[] buildParamList(Functor func, int indexOfParamToSetToNull) {
        Class<?>[] types = func.getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (i == indexOfParamToSetToNull) continue;
            params[i] = this.defaults.get(types[i]);
            if (NullPointerTester.parameterIsPrimitiveOrNullable(func, i)) continue;
            Assert.assertTrue((String)("No default value found for " + types[i].getName()), (params[i] != null ? 1 : 0) != 0);
        }
        return params;
    }

    private static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    private static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private boolean isIgnored(Member member) {
        return member.isSynthetic() || this.ignoredMembers.contains(member);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Functor {
        public Class<?>[] getParameterTypes();

        public Annotation[][] getParameterAnnotations();

        public void invoke(Object var1, Object[] var2) throws Exception;
    }
}

