/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetIteratorTester;
import com.google.common.collect.testing.google.MultisetReadsTester;
import com.google.common.collect.testing.google.MultisetSerializationTester;
import com.google.common.collect.testing.google.MultisetSetCountConditionallyTester;
import com.google.common.collect.testing.google.MultisetSetCountUnconditionallyTester;
import com.google.common.collect.testing.google.MultisetWritesTester;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.testers.CollectionSerializationEqualTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

@GwtCompatible
public class MultisetTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<MultisetTestSuiteBuilder<E>, E> {
    public static <E> MultisetTestSuiteBuilder<E> using(TestMultisetGenerator<E> generator) {
        return (MultisetTestSuiteBuilder)new MultisetTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(CollectionSerializationEqualTester.class);
        testers.add(MultisetReadsTester.class);
        testers.add(MultisetSetCountConditionallyTester.class);
        testers.add(MultisetSetCountUnconditionallyTester.class);
        testers.add(MultisetWritesTester.class);
        testers.add(MultisetIteratorTester.class);
        testers.add(MultisetSerializationTester.class);
        return testers;
    }

    private static Set<Feature<?>> computeReserializedMultisetFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet();
        derivedFeatures.addAll(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using(new ReserializedMultisetGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(MultisetTestSuiteBuilder.computeReserializedMultisetFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        return derivedSuites;
    }

    static class ReserializedMultisetGenerator<E>
    implements TestMultisetGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedMultisetGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public Multiset<E> create(Object ... elements) {
            return (Multiset)SerializableTester.reserialize(this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }
}

