/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;

public class MapRemoveTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_present() {
        int initialSize = this.getMap().size();
        MapRemoveTester.assertEquals((String)"remove(present) should return the associated value", ((Map.Entry)this.samples.e0).getValue(), this.getMap().remove(((Map.Entry)this.samples.e0).getKey()));
        MapRemoveTester.assertEquals((String)"remove(present) should decrease a map's size by one.", (int)(initialSize - 1), (int)this.getMap().size());
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemovePresentConcurrentWithEntrySetIteration() {
        try {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
            iterator.next();
            MapRemoveTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemovePresentConcurrentWithKeySetIteration() {
        try {
            Iterator iterator = this.getMap().keySet().iterator();
            this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
            iterator.next();
            MapRemoveTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemovePresentConcurrentWithValuesIteration() {
        try {
            Iterator iterator = this.getMap().values().iterator();
            this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
            iterator.next();
            MapRemoveTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_notPresent() {
        MapRemoveTester.assertNull((String)"remove(notPresent) should return null", this.getMap().remove(((Map.Entry)this.samples.e3).getKey()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_nullPresent() {
        this.initMapWithNullKey();
        int initialSize = this.getMap().size();
        MapRemoveTester.assertEquals((String)"remove(null) should return the associated value", this.getValueForNullKey(), this.getMap().remove(null));
        MapRemoveTester.assertEquals((String)"remove(present) should decrease a map's size by one.", (int)(initialSize - 1), (int)this.getMap().size());
        this.expectMissing(this.entry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupported() {
        try {
            this.getMap().remove(((Map.Entry)this.samples.e0).getKey());
            MapRemoveTester.fail((String)"remove(present) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        MapRemoveTester.assertEquals((String)"remove(present) should not remove the element", ((Map.Entry)this.samples.e0).getValue(), this.get(((Map.Entry)this.samples.e0).getKey()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedNotPresent() {
        try {
            MapRemoveTester.assertNull((String)"remove(notPresent) should return null or throw UnsupportedOperationException", this.getMap().remove(((Map.Entry)this.samples.e3).getKey()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.samples.e3);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullQueriesNotSupported() {
        try {
            MapRemoveTester.assertNull((String)"remove(null) should return null or throw NullPointerException", this.getMap().remove(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullSupportedMissing() {
        MapRemoveTester.assertNull((String)"remove(null) should return null", this.getMap().remove(null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_wrongType() {
        try {
            MapRemoveTester.assertNull(this.getMap().remove((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

