/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.DerivedGenerator;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapClearTester;
import com.google.common.collect.testing.testers.MapContainsKeyTester;
import com.google.common.collect.testing.testers.MapContainsValueTester;
import com.google.common.collect.testing.testers.MapCreationTester;
import com.google.common.collect.testing.testers.MapEqualsTester;
import com.google.common.collect.testing.testers.MapGetTester;
import com.google.common.collect.testing.testers.MapHashCodeTester;
import com.google.common.collect.testing.testers.MapIsEmptyTester;
import com.google.common.collect.testing.testers.MapPutAllTester;
import com.google.common.collect.testing.testers.MapPutTester;
import com.google.common.collect.testing.testers.MapRemoveTester;
import com.google.common.collect.testing.testers.MapSerializationTester;
import com.google.common.collect.testing.testers.MapSizeTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class MapTestSuiteBuilder<K, V>
extends PerCollectionSizeTestSuiteBuilder<MapTestSuiteBuilder<K, V>, TestMapGenerator<K, V>, Map<K, V>, Map.Entry<K, V>> {
    public static <K, V> MapTestSuiteBuilder<K, V> using(TestMapGenerator<K, V> generator) {
        return (MapTestSuiteBuilder)new MapTestSuiteBuilder<K, V>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        return Arrays.asList(MapClearTester.class, MapContainsKeyTester.class, MapContainsValueTester.class, MapCreationTester.class, MapEqualsTester.class, MapGetTester.class, MapHashCodeTester.class, MapIsEmptyTester.class, MapPutTester.class, MapPutAllTester.class, MapRemoveTester.class, MapSerializationTester.class, MapSizeTester.class);
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new ReserializedMapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeReserializedMapFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " reserialized")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new MapEntrySetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeEntrySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " entrySet")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)this.createDerivedKeySetSuite(new MapKeySetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeKeySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " keys")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        derivedSuites.add(((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new MapValueCollectionGenerator<K, V>(parentBuilder.getSubjectGenerator())).named(parentBuilder.getName() + " values")).withFeatures(MapTestSuiteBuilder.computeValuesCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        return derivedSuites;
    }

    protected SetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return SetTestSuiteBuilder.using(keySetGenerator);
    }

    private static Set<Feature<?>> computeReserializedMapFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(mapFeatures);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    private static Set<Feature<?>> computeEntrySetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> entrySetFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        entrySetFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        return entrySetFeatures;
    }

    private static Set<Feature<?>> computeKeySetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> keySetFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_KEYS)) {
            keySetFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        } else if (mapFeatures.contains(MapFeature.ALLOWS_NULL_QUERIES)) {
            keySetFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return keySetFeatures;
    }

    private static Set<Feature<?>> computeValuesCollectionFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> valuesCollectionFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_QUERIES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        return valuesCollectionFeatures;
    }

    private static Set<Feature<?>> computeCommonDerivedCollectionFeatures(Set<Feature<?>> mapFeatures) {
        HashSet derivedFeatures = new HashSet();
        if (mapFeatures.contains(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.add(CollectionFeature.SERIALIZABLE);
        }
        if (mapFeatures.contains(MapFeature.SUPPORTS_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE);
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE_ALL);
            derivedFeatures.add(CollectionFeature.SUPPORTS_RETAIN_ALL);
        }
        if (mapFeatures.contains(MapFeature.SUPPORTS_CLEAR)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_CLEAR);
        }
        if (mapFeatures.contains(MapFeature.REJECTS_DUPLICATES_AT_CREATION)) {
            derivedFeatures.add(CollectionFeature.REJECTS_DUPLICATES_AT_CREATION);
        }
        if (mapFeatures.contains(MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION)) {
            derivedFeatures.add(CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION);
        }
        if (mapFeatures.contains(CollectionFeature.KNOWN_ORDER)) {
            derivedFeatures.add(CollectionFeature.KNOWN_ORDER);
        }
        for (CollectionSize size : CollectionSize.values()) {
            if (!mapFeatures.contains(size)) continue;
            derivedFeatures.add(size);
        }
        return derivedFeatures;
    }

    public static class MapValueCollectionGenerator<K, V>
    implements TestCollectionGenerator<V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<V> samples;

        public MapValueCollectionGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getValue(), ((Map.Entry)mapSamples.e1).getValue(), ((Map.Entry)mapSamples.e2).getValue(), ((Map.Entry)mapSamples.e3).getValue(), ((Map.Entry)mapSamples.e4).getValue());
        }

        @Override
        public SampleElements<V> samples() {
            return this.samples;
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Object[] valuesArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(entry.getKey(), valuesArray[i++]));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).values();
        }

        @Override
        public V[] createArray(int length) {
            V[] vs = ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
            return vs;
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            final List<Map.Entry<K, V>> orderedEntries = Helpers.castOrCopyToList(this.mapGenerator.order(Helpers.castOrCopyToList(this.mapGenerator.getSampleElements(5))));
            Collections.sort(insertionOrder, new Comparator<V>(){

                @Override
                public int compare(V left, V right) {
                    return this.indexOfEntryWithValue(left) - this.indexOfEntryWithValue(right);
                }

                int indexOfEntryWithValue(V value) {
                    for (int i = 0; i < orderedEntries.size(); ++i) {
                        if (!Helpers.equal(((Map.Entry)orderedEntries.get(i)).getValue(), value)) continue;
                        return i;
                    }
                    throw new IllegalArgumentException("Map.values generator can order only sample values");
                }
            });
            return insertionOrder;
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class MapKeySetGenerator<K, V>
    implements TestSetGenerator<K>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<K> samples;

        public MapKeySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getKey(), ((Map.Entry)mapSamples.e1).getKey(), ((Map.Entry)mapSamples.e2).getKey(), ((Map.Entry)mapSamples.e3).getKey(), ((Map.Entry)mapSamples.e4).getKey());
        }

        @Override
        public SampleElements<K> samples() {
            return this.samples;
        }

        @Override
        public Set<K> create(Object ... elements) {
            Object[] keysArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<Object, V>> entries = new ArrayList<Map.Entry<Object, V>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(keysArray[i++], entry.getValue()));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).keySet();
        }

        @Override
        public K[] createArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public Iterable<K> order(List<K> insertionOrder) {
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>();
            for (K element : insertionOrder) {
                entries.add(Helpers.mapEntry(element, null));
            }
            ArrayList keys = new ArrayList();
            for (Map.Entry entry : this.mapGenerator.order(entries)) {
                keys.add(entry.getKey());
            }
            return keys;
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class MapEntrySetGenerator<K, V>
    implements TestSetGenerator<Map.Entry<K, V>>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;

        public MapEntrySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.mapGenerator.samples();
        }

        @Override
        public Set<Map.Entry<K, V>> create(Object ... elements) {
            return ((Map)this.mapGenerator.create(elements)).entrySet();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.mapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.mapGenerator.order(insertionOrder);
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    private static class ReserializedMapGenerator<K, V>
    implements TestMapGenerator<K, V> {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;

        public ReserializedMapGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.mapGenerator.samples();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.mapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.mapGenerator.order(insertionOrder);
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)SerializableTester.reserialize(this.mapGenerator.create(elements));
        }

        @Override
        public K[] createKeyArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
        }
    }
}

