/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.MapInterfaceTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public abstract class SortedMapInterfaceTest<K, V>
extends MapInterfaceTest<K, V> {
    protected SortedMapInterfaceTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear) {
        super(allowsNullKeys, allowsNullValues, supportsPut, supportsRemove, supportsClear);
    }

    @Override
    protected abstract SortedMap<K, V> makeEmptyMap() throws UnsupportedOperationException;

    @Override
    protected abstract SortedMap<K, V> makePopulatedMap() throws UnsupportedOperationException;

    @Override
    protected SortedMap<K, V> makeEitherMap() {
        try {
            return this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return this.makeEmptyMap();
        }
    }

    public void testOrdering() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        Object prior = iterator.next();
        Comparator comparator = map.comparator();
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (comparator == null) {
                Comparable comparable = (Comparable)prior;
                SortedMapInterfaceTest.assertTrue((comparable.compareTo(current) < 0 ? 1 : 0) != 0);
            } else {
                SortedMapInterfaceTest.assertTrue((map.comparator().compare(prior, current) < 0 ? 1 : 0) != 0);
            }
            current = prior;
        }
    }

    public void testEntrySetContainsEntryIncompatibleComparableKey() {
        Object unmappedValue;
        Map map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set entrySet = map.entrySet();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Map.Entry entry = SortedMapInterfaceTest.mapEntry(new IncompatibleComparableKeyType(), unmappedValue);
        SortedMapInterfaceTest.assertFalse((boolean)entrySet.contains(entry));
    }

    public void testFirstKeyEmpty() {
        Map map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            map.firstKey();
            SortedMapInterfaceTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.assertInvariants(map);
    }

    public void testFirstKeyNonEmpty() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object expected = map.keySet().iterator().next();
        SortedMapInterfaceTest.assertEquals(expected, map.firstKey());
        this.assertInvariants(map);
    }

    public void testLastKeyEmpty() {
        Map map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            map.lastKey();
            SortedMapInterfaceTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.assertInvariants(map);
    }

    public void testLastKeyNonEmpty() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Object expected = null;
        for (Object key : map.keySet()) {
            expected = key;
        }
        SortedMapInterfaceTest.assertEquals(expected, map.lastKey());
        this.assertInvariants(map);
    }

    private static <E> List<E> toList(Collection<E> collection) {
        return new ArrayList<E>(collection);
    }

    private static <E> List<E> subListSnapshot(List<E> list, int fromIndex, int toIndex) {
        ArrayList<E> subList = new ArrayList<E>();
        for (int i = fromIndex; i < toIndex; ++i) {
            subList.add(list.get(i));
        }
        return Collections.unmodifiableList(subList);
    }

    public void testHeadMap() {
        Map map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        List list = SortedMapInterfaceTest.toList(map.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            List expected = SortedMapInterfaceTest.subListSnapshot(list, 0, i);
            SortedMap headMap = map.headMap(list.get(i).getKey());
            SortedMapInterfaceTest.assertEquals(expected, SortedMapInterfaceTest.toList(headMap.entrySet()));
        }
    }

    public void testTailMap() {
        Map map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        List list = SortedMapInterfaceTest.toList(map.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            List expected = SortedMapInterfaceTest.subListSnapshot(list, i, list.size());
            SortedMap tailMap = map.tailMap(list.get(i).getKey());
            SortedMapInterfaceTest.assertEquals(expected, SortedMapInterfaceTest.toList(tailMap.entrySet()));
        }
    }

    public void testSubMap() {
        Map map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        List list = SortedMapInterfaceTest.toList(map.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                List expected = SortedMapInterfaceTest.subListSnapshot(list, i, j);
                SortedMap subMap = map.subMap(list.get(i).getKey(), list.get(j).getKey());
                SortedMapInterfaceTest.assertEquals(expected, SortedMapInterfaceTest.toList(subMap.entrySet()));
            }
        }
    }

    public void testSubMapIllegal() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (map.size() < 2) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        Object first = iterator.next();
        Object second = iterator.next();
        try {
            map.subMap(second, first);
            SortedMapInterfaceTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testTailMapEntrySet() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (map.size() < 3) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        Map.Entry secondEntry = iterator.next();
        Map.Entry thirdEntry = iterator.next();
        SortedMap tail = map.tailMap(secondEntry.getKey());
        Set tailEntrySet = tail.entrySet();
        SortedMapInterfaceTest.assertTrue((boolean)tailEntrySet.contains(thirdEntry));
        SortedMapInterfaceTest.assertTrue((boolean)tailEntrySet.contains(secondEntry));
        SortedMapInterfaceTest.assertFalse((boolean)tailEntrySet.contains(firstEntry));
        SortedMapInterfaceTest.assertEquals(tail.firstKey(), secondEntry.getKey());
    }

    public void testHeadMapEntrySet() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (map.size() < 3) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        Map.Entry secondEntry = iterator.next();
        Map.Entry thirdEntry = iterator.next();
        SortedMap head = map.headMap(secondEntry.getKey());
        Set headEntrySet = head.entrySet();
        SortedMapInterfaceTest.assertFalse((boolean)headEntrySet.contains(thirdEntry));
        SortedMapInterfaceTest.assertFalse((boolean)headEntrySet.contains(secondEntry));
        SortedMapInterfaceTest.assertTrue((boolean)headEntrySet.contains(firstEntry));
        SortedMapInterfaceTest.assertEquals(head.firstKey(), firstEntry.getKey());
        SortedMapInterfaceTest.assertEquals(head.lastKey(), firstEntry.getKey());
    }

    public void testTailMapWriteThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (map.size() < 2 || !this.supportsPut) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        Map.Entry secondEntry = iterator.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        Object value = this.getValueNotInPopulatedMap();
        subMap.put(key, value);
        SortedMapInterfaceTest.assertEquals(secondEntry.getValue(), value);
        SortedMapInterfaceTest.assertEquals(map.get(key), value);
        try {
            subMap.put(firstEntry.getKey(), value);
            SortedMapInterfaceTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testTailMapRemoveThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int oldSize = map.size();
        if (map.size() < 2 || !this.supportsRemove) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        Map.Entry secondEntry = iterator.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        subMap.remove(key);
        SortedMapInterfaceTest.assertNull(subMap.remove(firstEntry.getKey()));
        SortedMapInterfaceTest.assertEquals((int)map.size(), (int)(oldSize - 1));
        SortedMapInterfaceTest.assertFalse((boolean)map.containsKey(key));
        SortedMapInterfaceTest.assertEquals((int)subMap.size(), (int)(oldSize - 2));
    }

    public void testTailMapClearThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int oldSize = map.size();
        if (map.size() < 2 || !this.supportsClear) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        Map.Entry secondEntry = iterator.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        int subMapSize = subMap.size();
        subMap.clear();
        SortedMapInterfaceTest.assertEquals((int)map.size(), (int)(oldSize - subMapSize));
        SortedMapInterfaceTest.assertTrue((boolean)subMap.isEmpty());
    }

    private static final class IncompatibleComparableKeyType
    implements Comparable<IncompatibleComparableKeyType> {
        private IncompatibleComparableKeyType() {
        }

        public String toString() {
            return "IncompatibleComparableKeyType";
        }

        @Override
        public int compareTo(IncompatibleComparableKeyType o) {
            throw new ClassCastException();
        }
    }
}

