/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.SortedSetTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.SortedMapNavigationTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import junit.framework.TestSuite;

public class SortedMapTestSuiteBuilder<K, V>
extends MapTestSuiteBuilder<K, V> {
    public static <K, V> SortedMapTestSuiteBuilder<K, V> using(TestMapGenerator<K, V> generator) {
        SortedMapTestSuiteBuilder<K, V> result = new SortedMapTestSuiteBuilder<K, V>();
        result.usingGenerator(generator);
        return result;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(SortedMapNavigationTester.class);
        return testers;
    }

    @Override
    public TestSuite createTestSuite() {
        if (!this.getFeatures().contains(CollectionFeature.KNOWN_ORDER)) {
            List<Feature<?>> features = Helpers.copyToList(this.getFeatures());
            features.add(CollectionFeature.KNOWN_ORDER);
            this.withFeatures(features);
        }
        return super.createTestSuite();
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (!parentBuilder.getFeatures().contains(NoRecurse.SUBMAP)) {
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.NO_BOUND, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.INCLUSIVE, Bound.NO_BOUND));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, Bound.INCLUSIVE, Bound.EXCLUSIVE));
        }
        return derivedSuites;
    }

    @Override
    protected SetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return keySetGenerator.create(new Object[0]) instanceof SortedSet ? SortedSetTestSuiteBuilder.using(keySetGenerator) : SetTestSuiteBuilder.using(keySetGenerator);
    }

    final TestSuite createSubmapSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder, Bound from, Bound to) {
        TestMapGenerator delegate = (TestMapGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(NoRecurse.SUBMAP);
        features.addAll(parentBuilder.getFeatures());
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)this.newBuilderUsing(delegate, to, from).named(parentBuilder.getName() + " subMap " + (Object)((Object)from) + "-" + (Object)((Object)to))).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    SortedMapTestSuiteBuilder<K, V> newBuilderUsing(TestMapGenerator<K, V> delegate, Bound to, Bound from) {
        return SortedMapTestSuiteBuilder.using(new SortedMapSubmapTestMapGenerator<K, V>(delegate, to, from));
    }

    private static List<Map.Entry<String, String>> getExtremeValues() {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        result.add(Helpers.mapEntry("!! a", "below view"));
        result.add(Helpers.mapEntry("!! b", "below view"));
        result.add(Helpers.mapEntry("~~ y", "above view"));
        result.add(Helpers.mapEntry("~~ z", "above view"));
        return result;
    }

    static class ForwardingTestMapGenerator<K, V>
    implements TestMapGenerator<K, V> {
        TestMapGenerator<K, V> delegate;

        ForwardingTestMapGenerator(TestMapGenerator<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.delegate.order(insertionOrder);
        }

        @Override
        public K[] createKeyArray(int length) {
            return this.delegate.createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return this.delegate.createValueArray(length);
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.delegate.samples();
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)this.delegate.create(elements);
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.delegate.createArray(length);
        }
    }

    public static class SortedMapSubmapTestMapGenerator<K, V>
    extends ForwardingTestMapGenerator<K, V> {
        final Bound to;
        final Bound from;
        final K firstInclusive;
        final K lastInclusive;
        private final Comparator<Map.Entry<K, V>> entryComparator;

        public SortedMapSubmapTestMapGenerator(TestMapGenerator<K, V> delegate, Bound to, Bound from) {
            super(delegate);
            this.to = to;
            this.from = from;
            SortedMap emptyMap = (SortedMap)delegate.create(new Object[0]);
            this.entryComparator = Helpers.entryComparator(emptyMap.comparator());
            SampleElements samples = delegate.samples();
            List<Map.Entry> samplesList = Arrays.asList((Map.Entry)samples.e0, (Map.Entry)samples.e1, (Map.Entry)samples.e2, (Map.Entry)samples.e3, (Map.Entry)samples.e4);
            Collections.sort(samplesList, this.entryComparator);
            this.firstInclusive = samplesList.get(0).getKey();
            this.lastInclusive = samplesList.get(samplesList.size() - 1).getKey();
        }

        @Override
        public Map<K, V> create(Object ... entries) {
            List extremeValues = SortedMapTestSuiteBuilder.getExtremeValues();
            List<Object> normalValues = Arrays.asList(entries);
            Collections.sort(extremeValues, this.entryComparator);
            Object firstExclusive = ((Map.Entry)extremeValues.get(1)).getKey();
            Object lastExclusive = ((Map.Entry)extremeValues.get(2)).getKey();
            if (this.from == Bound.NO_BOUND) {
                extremeValues.remove(0);
                extremeValues.remove(0);
            }
            if (this.to == Bound.NO_BOUND) {
                extremeValues.remove(extremeValues.size() - 1);
                extremeValues.remove(extremeValues.size() - 1);
            }
            ArrayList<Object> allEntries = new ArrayList<Object>();
            allEntries.addAll(extremeValues);
            allEntries.addAll(normalValues);
            SortedMap map = (SortedMap)this.delegate.create(allEntries.toArray(new Map.Entry[allEntries.size()]));
            return this.createSubMap(map, firstExclusive, lastExclusive);
        }

        Map<K, V> createSubMap(SortedMap<K, V> map, K firstExclusive, K lastExclusive) {
            if (this.from == Bound.NO_BOUND && this.to == Bound.EXCLUSIVE) {
                return map.headMap(lastExclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.NO_BOUND) {
                return map.tailMap(this.firstInclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.EXCLUSIVE) {
                return map.subMap(this.firstInclusive, lastExclusive);
            }
            throw new IllegalArgumentException();
        }

        public final Bound getTo() {
            return this.to;
        }

        public final Bound getFrom() {
            return this.from;
        }

        public final TestMapGenerator<K, V> getInnerGenerator() {
            return this.delegate;
        }
    }

    public static enum Bound {
        INCLUSIVE,
        EXCLUSIVE,
        NO_BOUND;

    }

    static enum NoRecurse implements Feature<Void>
    {
        SUBMAP,
        DESCENDING;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

