/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.Platform;
import java.lang.reflect.Method;
import java.util.Collection;

public class CollectionCreationTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_supported() {
        Object[] array = this.createArrayWithNullElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        this.expectContents(array);
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_unsupported() {
        Object[] array = this.createArrayWithNullElement();
        try {
            ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
            CollectionCreationTester.fail((String)"Creating a collection containing null should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Method getCreateWithNullUnsupportedMethod() {
        return Platform.getMethod(CollectionCreationTester.class, "testCreateWithNull_unsupported");
    }
}

