/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;

public class ListAddAllTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedAllPresent() {
        ListAddAllTester.assertTrue((String)"addAll(allPresent) should return true", (boolean)this.getList().addAll(MinimalCollection.of(this.samples.e0)));
        this.expectAdded(this.samples.e0);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_unsupportedAllPresent() {
        try {
            this.getList().addAll(MinimalCollection.of(this.samples.e0));
            ListAddAllTester.fail((String)"addAll(allPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD_ALL})
    public void testAddAll_withDuplicates() {
        MinimalCollection<Object> elementsToAdd = MinimalCollection.of(this.samples.e0, this.samples.e1, this.samples.e0, this.samples.e1);
        ListAddAllTester.assertTrue((String)"addAll(hasDuplicates) should return true", (boolean)this.getList().addAll(elementsToAdd));
        this.expectAdded(this.samples.e0, this.samples.e1, this.samples.e0, this.samples.e1);
    }
}

