/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.collect.testing.testers.Platform;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class ListRemoveAtIndexTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(absent={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_unsupported() {
        try {
            this.getList().remove(0);
            ListRemoveAtIndexTester.fail((String)"remove(i) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    public void testRemoveAtIndex_negative() {
        try {
            this.getList().remove(-1);
            ListRemoveAtIndexTester.fail((String)"remove(-1) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    public void testRemoveAtIndex_tooLarge() {
        try {
            this.getList().remove(this.getNumElements());
            ListRemoveAtIndexTester.fail((String)"remove(size) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_first() {
        this.runRemoveTest(0);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRemoveAtIndex_middle() {
        this.runRemoveTest(this.getNumElements() / 2);
    }

    @CollectionFeature.Require(value={CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndexConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            this.getList().remove(this.getNumElements() / 2);
            iterator.next();
            ListRemoveAtIndexTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAtIndex_last() {
        this.runRemoveTest(this.getNumElements() - 1);
    }

    private void runRemoveTest(int index) {
        ListRemoveAtIndexTester.assertEquals((String)Platform.format("remove(%d) should return the element at index %d", index, index), this.getList().get(index), this.getList().remove(index));
        List expected = Helpers.copyToList(this.createSamplesArray());
        expected.remove(index);
        this.expectContents(expected);
    }
}

