/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.DerivedGenerator;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSubjectGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapClearTester;
import com.google.common.collect.testing.google.BiMapInverseTester;
import com.google.common.collect.testing.google.BiMapPutTester;
import com.google.common.collect.testing.google.BiMapRemoveTester;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

@GwtCompatible
public class BiMapTestSuiteBuilder<K, V>
extends PerCollectionSizeTestSuiteBuilder<BiMapTestSuiteBuilder<K, V>, TestBiMapGenerator<K, V>, BiMap<K, V>, Map.Entry<K, V>> {
    public static <K, V> BiMapTestSuiteBuilder<K, V> using(TestBiMapGenerator<K, V> generator) {
        return (BiMapTestSuiteBuilder)new BiMapTestSuiteBuilder<K, V>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        ArrayList<Class<? extends AbstractTester>> testers = new ArrayList<Class<? extends AbstractTester>>();
        testers.add(BiMapPutTester.class);
        testers.add(BiMapInverseTester.class);
        testers.add(BiMapRemoveTester.class);
        testers.add(BiMapClearTester.class);
        return testers;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derived = super.createDerivedSuites(parentBuilder);
        derived.add(((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new MapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(parentBuilder.getFeatures())).named(parentBuilder.getName() + " [Map]")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        derived.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new BiMapValueSetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(BiMapTestSuiteBuilder.computeValuesSetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " values [Set]")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        if (!parentBuilder.getFeatures().contains(NoRecurse.INVERSE)) {
            derived.add(((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using(new InverseBiMapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(BiMapTestSuiteBuilder.computeInverseFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " inverse")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        return derived;
    }

    private static Set<Feature<?>> computeInverseFeatures(Set<Feature<?>> mapFeatures) {
        HashSet inverseFeatures = new HashSet(mapFeatures);
        boolean nullKeys = inverseFeatures.remove(MapFeature.ALLOWS_NULL_KEYS);
        boolean nullValues = inverseFeatures.remove(MapFeature.ALLOWS_NULL_VALUES);
        if (nullKeys) {
            inverseFeatures.add(MapFeature.ALLOWS_NULL_VALUES);
        }
        if (nullValues) {
            inverseFeatures.add(MapFeature.ALLOWS_NULL_KEYS);
        }
        inverseFeatures.add(NoRecurse.INVERSE);
        inverseFeatures.remove(CollectionFeature.KNOWN_ORDER);
        return inverseFeatures;
    }

    private static Set<Feature<?>> computeValuesSetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> valuesCollectionFeatures = BiMapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        return valuesCollectionFeatures;
    }

    private static Set<Feature<?>> computeCommonDerivedCollectionFeatures(Set<Feature<?>> mapFeatures) {
        HashSet derivedFeatures = new HashSet();
        if (mapFeatures.contains(MapFeature.SUPPORTS_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE);
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE_ALL);
            derivedFeatures.add(CollectionFeature.SUPPORTS_RETAIN_ALL);
        }
        if (mapFeatures.contains(MapFeature.SUPPORTS_CLEAR)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_CLEAR);
        }
        if (mapFeatures.contains(MapFeature.REJECTS_DUPLICATES_AT_CREATION)) {
            derivedFeatures.add(CollectionFeature.REJECTS_DUPLICATES_AT_CREATION);
        }
        for (CollectionSize size : CollectionSize.values()) {
            if (!mapFeatures.contains(size)) continue;
            derivedFeatures.add(size);
        }
        return derivedFeatures;
    }

    public static class BiMapValueSetGenerator<K, V>
    implements TestSetGenerator<V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<V> samples;

        public BiMapValueSetGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getValue(), ((Map.Entry)mapSamples.e1).getValue(), ((Map.Entry)mapSamples.e2).getValue(), ((Map.Entry)mapSamples.e3).getValue(), ((Map.Entry)mapSamples.e4).getValue());
        }

        @Override
        public SampleElements<V> samples() {
            return this.samples;
        }

        @Override
        public Set<V> create(Object ... elements) {
            Object[] valuesArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(entry.getKey(), valuesArray[i++]));
            }
            return ((BiMap)this.mapGenerator.create(entries.toArray())).values();
        }

        @Override
        public V[] createArray(int length) {
            V[] vs = ((TestBiMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
            return vs;
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            return insertionOrder;
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class InverseBiMapGenerator<K, V>
    implements TestBiMapGenerator<V, K>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> generator;

        public InverseBiMapGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> oneSizeTestContainerGenerator) {
            this.generator = oneSizeTestContainerGenerator;
        }

        @Override
        public SampleElements<Map.Entry<V, K>> samples() {
            SampleElements samples = this.generator.samples();
            return new SampleElements<Map.Entry<V, K>>(this.reverse((Map.Entry)samples.e0), this.reverse((Map.Entry)samples.e1), this.reverse((Map.Entry)samples.e2), this.reverse((Map.Entry)samples.e3), this.reverse((Map.Entry)samples.e4));
        }

        private Map.Entry<V, K> reverse(Map.Entry<K, V> entry) {
            return Helpers.mapEntry(entry.getValue(), entry.getKey());
        }

        @Override
        public BiMap<V, K> create(Object ... elements) {
            Map.Entry[] entries = new Map.Entry[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                entries[i] = this.reverse((Map.Entry)elements[i]);
            }
            return ((BiMap)this.generator.create(entries)).inverse();
        }

        public Map.Entry<V, K>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<V, K>> order(List<Map.Entry<V, K>> insertionOrder) {
            return insertionOrder;
        }

        @Override
        public V[] createKeyArray(int length) {
            return new Object[length];
        }

        @Override
        public K[] createValueArray(int length) {
            return new Object[length];
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.generator;
        }
    }

    public static class MapGenerator<K, V>
    implements TestMapGenerator<K, V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> generator;

        public MapGenerator(OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>> oneSizeTestContainerGenerator) {
            this.generator = oneSizeTestContainerGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.generator.samples();
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)this.generator.create(elements);
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.generator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.generator.order(insertionOrder);
        }

        @Override
        public K[] createKeyArray(int length) {
            return new Object[length];
        }

        @Override
        public V[] createValueArray(int length) {
            return new Object[length];
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.generator;
        }
    }

    static enum NoRecurse implements Feature<Void>
    {
        INVERSE;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

