/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.testers.Platform;
import java.util.Collection;
import java.util.List;

public class AbstractListTester<E>
extends AbstractCollectionTester<E> {
    protected final List<E> getList() {
        return (List)this.collection;
    }

    @Override
    protected void expectContents(Collection<E> expectedCollection) {
        List<E> expectedList = Helpers.copyToList(expectedCollection);
        if (this.getList().size() != expectedList.size()) {
            AbstractListTester.fail((String)("size mismatch: " + this.reportContext(expectedList)));
        }
        for (int i = 0; i < expectedList.size(); ++i) {
            E actual;
            E expected = expectedList.get(i);
            if (expected == (actual = this.getList().get(i)) || expected != null && expected.equals(actual)) continue;
            AbstractListTester.fail((String)("mismatch at index " + i + ": " + this.reportContext(expectedList)));
        }
    }

    private String reportContext(List<E> expected) {
        return Platform.format("expected collection %s; actual collection %s", expected, this.collection);
    }
}

