/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SetCreationTester<E>
extends AbstractSetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES}, absent={CollectionFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesNotRejected() {
        Object[] array = this.createArrayWithNullElement();
        array[0] = null;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        List<Object> expectedWithDuplicateRemoved = Arrays.asList(array).subList(1, this.getNumElements());
        this.expectContents(expectedWithDuplicateRemoved);
    }

    @CollectionFeature.Require(absent={CollectionFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesNotRejected() {
        Object[] array = this.createSamplesArray();
        array[1] = this.samples.e0;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        List<Object> expectedWithDuplicateRemoved = Arrays.asList(array).subList(1, this.getNumElements());
        this.expectContents(expectedWithDuplicateRemoved);
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesRejected() {
        Object[] array = this.createArrayWithNullElement();
        array[0] = null;
        try {
            this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
            SetCreationTester.fail((String)"Should reject duplicate null elements at creation");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesRejected() {
        Object[] array = this.createSamplesArray();
        array[1] = this.samples.e0;
        try {
            this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
            SetCreationTester.fail((String)"Should reject duplicate non-null elements at creation");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

