/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class SortedMapNavigationTester<K, V>
extends AbstractMapTester<K, V> {
    private SortedMap<K, V> navigableMap;
    private Map.Entry<K, V> a;
    private Map.Entry<K, V> c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableMap = (SortedMap)this.getMap();
        List entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(entries, Helpers.entryComparator(this.navigableMap.comparator()));
        if (entries.size() >= 1) {
            this.a = (Map.Entry)entries.get(0);
            if (entries.size() >= 3) {
                this.c = (Map.Entry)entries.get(2);
            }
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapFirst() {
        try {
            this.navigableMap.firstKey();
            SortedMapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapLast() {
        try {
            SortedMapNavigationTester.assertNull(this.navigableMap.lastKey());
            SortedMapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapFirst() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapLast() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lastKey());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        SortedMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.lastKey());
    }
}

