/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class CollectionRemoveAllTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    public void testRemoveAll_emptyCollection() {
        CollectionRemoveAllTester.assertFalse((String)"removeAll(emptyCollection) should return false", (boolean)this.collection.removeAll(MinimalCollection.of(new Object[0])));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    public void testRemoveAll_nonePresent() {
        CollectionRemoveAllTester.assertFalse((String)"removeAll(disjointCollection) should return false", (boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e3)));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_allPresent() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(intersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e0)));
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_somePresent() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(intersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e0, this.samples.e3)));
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAllSomePresentConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            CollectionRemoveAllTester.assertTrue((boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e0, this.samples.e3)));
            iterator.next();
            CollectionRemoveAllTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_somePresentLargeCollectionToRemove() {
        CollectionRemoveAllTester.assertTrue((String)"removeAll(largeIntersectingCollection) should return true", (boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e0, this.samples.e0, this.samples.e0, this.samples.e3, this.samples.e3, this.samples.e3)));
        this.expectMissing(this.samples.e0);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE_ALL})
    public void testRemoveAll_unsupportedEmptyCollection() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(emptyCollection) should return false or throw UnsupportedOperationException", (boolean)this.collection.removeAll(MinimalCollection.of(new Object[0])));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE_ALL})
    public void testRemoveAll_unsupportedNonePresent() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(disjointCollection) should return false or throw UnsupportedOperationException", (boolean)this.collection.removeAll(MinimalCollection.of(this.samples.e3)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_unsupportedPresent() {
        try {
            this.collection.removeAll(MinimalCollection.of(this.samples.e0));
            CollectionRemoveAllTester.fail((String)"removeAll(intersectingCollection) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveAllTester.assertTrue((boolean)this.collection.contains(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRemoveAll_nullCollectionReferenceEmptySubject() {
        try {
            this.collection.removeAll(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_nullCollectionReferenceNonEmptySubject() {
        try {
            this.collection.removeAll(null);
            CollectionRemoveAllTester.fail((String)"removeAll(null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveAll_containsNullNo() {
        MinimalCollection<Object> containsNull = MinimalCollection.of(new Object[]{null});
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(containsNull) should return false or throw", (boolean)this.collection.removeAll(containsNull));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveAll_containsNullNoButAllowed() {
        MinimalCollection<Object> containsNull = MinimalCollection.of(new Object[]{null});
        CollectionRemoveAllTester.assertFalse((String)"removeAll(containsNull) should return false", (boolean)this.collection.removeAll(containsNull));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveAll_containsNullYes() {
        this.initCollectionWithNullElement();
        CollectionRemoveAllTester.assertTrue((String)"removeAll(containsNull) should return true", (boolean)this.collection.removeAll(Collections.singleton(null)));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE_ALL})
    public void testRemoveAll_containsWrongType() {
        try {
            CollectionRemoveAllTester.assertFalse((String)"removeAll(containsWrongType) should return false or throw", (boolean)this.collection.removeAll(MinimalCollection.of(WrongType.VALUE)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

