/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@GwtCompatible
public class SetMultimapPutAllTester<K, V>
extends AbstractMultimapTester<K, V, SetMultimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testReplaceValuesHandlesDuplicates() {
        Object v0 = this.sampleValues().e3;
        Object v1 = this.sampleValues().e2;
        List<Object> valuesToPut = Arrays.asList(v0, v1, v0);
        for (Object k : this.sampleKeys()) {
            this.resetContainer();
            Set<Object> expectedValues = Helpers.copyToSet(((SetMultimap)this.multimap()).get(k));
            ((SetMultimap)this.multimap()).putAll(k, valuesToPut);
            expectedValues.addAll(valuesToPut);
            this.assertGet(k, expectedValues);
        }
    }
}

