/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.testing.DummyProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@Beta
public final class NullPointerTester {
    private final ClassToInstanceMap<Object> defaults = MutableClassToInstanceMap.create();
    private final List<Member> ignoredMembers = Lists.newArrayList();

    public <T> NullPointerTester setDefault(Class<T> type, T value) {
        this.defaults.putInstance(type, Preconditions.checkNotNull(value));
        return this;
    }

    public NullPointerTester ignore(Method method) {
        this.ignoredMembers.add((Member)Preconditions.checkNotNull((Object)method));
        return this;
    }

    public void testConstructors(Class<?> c, Visibility minimalVisibility) {
        for (Constructor<?> constructor : c.getDeclaredConstructors()) {
            if (!minimalVisibility.isVisible(constructor) || this.isIgnored(constructor)) continue;
            this.testConstructor(constructor);
        }
    }

    public void testAllPublicConstructors(Class<?> c) {
        this.testConstructors(c, Visibility.PUBLIC);
    }

    public void testStaticMethods(Class<?> c, Visibility minimalVisibility) {
        for (Method method : minimalVisibility.getStaticMethods(c)) {
            if (this.isIgnored(method)) continue;
            this.testMethod(null, method);
        }
    }

    public void testAllPublicStaticMethods(Class<?> c) {
        this.testStaticMethods(c, Visibility.PUBLIC);
    }

    public void testInstanceMethods(Object instance, Visibility minimalVisibility) {
        for (Method method : this.getInstanceMethodsToTest(instance.getClass(), minimalVisibility)) {
            this.testMethod(instance, method);
        }
    }

    ImmutableList<Method> getInstanceMethodsToTest(Class<?> c, Visibility minimalVisibility) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : minimalVisibility.getInstanceMethods(c)) {
            if (this.isIgnored(method)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    public void testAllPublicInstanceMethods(Object instance) {
        this.testInstanceMethods(instance, Visibility.PUBLIC);
    }

    public void testMethod(@Nullable Object instance, Method method) {
        Class<?>[] types = method.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testMethodParameter(instance, method, nullIndex);
        }
    }

    public void testConstructor(Constructor<?> ctor) {
        Class<?> declaringClass = ctor.getDeclaringClass();
        Preconditions.checkArgument((Modifier.isStatic(declaringClass.getModifiers()) || declaringClass.getEnclosingClass() == null ? 1 : 0) != 0, (String)"Cannot test constructor of non-static inner class: %s", (Object[])new Object[]{declaringClass.getName()});
        Class<?>[] types = ctor.getParameterTypes();
        for (int nullIndex = 0; nullIndex < types.length; ++nullIndex) {
            this.testConstructorParameter(ctor, nullIndex);
        }
    }

    public void testMethodParameter(@Nullable Object instance, Method method, int paramIndex) {
        method.setAccessible(true);
        this.testParameter(instance, NullPointerTester.invokable(instance, method), paramIndex, method.getDeclaringClass());
    }

    public void testConstructorParameter(Constructor<?> ctor, int paramIndex) {
        ctor.setAccessible(true);
        this.testParameter(null, Invokable.from(ctor), paramIndex, ctor.getDeclaringClass());
    }

    private void testParameter(Object instance, Invokable<?, ?> invokable, int paramIndex, Class<?> testedClass) {
        if (NullPointerTester.isPrimitiveOrNullable((Parameter)invokable.getParameters().get(paramIndex))) {
            return;
        }
        Object[] params = this.buildParamList(invokable, paramIndex);
        try {
            Invokable<?, ?> unsafe = invokable;
            unsafe.invoke(instance, params);
            Assert.fail((String)("No exception thrown from " + invokable + Arrays.toString(params) + " for " + testedClass));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NullPointerException || cause instanceof UnsupportedOperationException) {
                return;
            }
            AssertionFailedError error = new AssertionFailedError("wrong exception thrown from " + invokable + ": " + cause);
            error.initCause(cause);
            throw error;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] buildParamList(Invokable<?, ?> invokable, int indexOfParamToSetToNull) {
        ImmutableList params = invokable.getParameters();
        Object[] args = new Object[params.size()];
        for (int i = 0; i < args.length; ++i) {
            Parameter param = (Parameter)params.get(i);
            if (i == indexOfParamToSetToNull) continue;
            args[i] = this.getDefaultValue(param.getType());
            if (NullPointerTester.isPrimitiveOrNullable(param)) continue;
            Assert.assertTrue((String)("No default value found for " + param + " of " + invokable), (args[i] != null ? 1 : 0) != 0);
        }
        return args;
    }

    private <T> T getDefaultValue(TypeToken<T> type) {
        Object defaultValue = this.defaults.getInstance(type.getRawType());
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        Object nullValue = ArbitraryInstances.get(type.getRawType());
        if (nullValue != null) {
            return nullValue;
        }
        if (type.getRawType() == Class.class) {
            Class defaultClass = NullPointerTester.getFirstTypeParameter(type.getType()).getRawType();
            return (T)defaultClass;
        }
        if (type.getRawType() == TypeToken.class) {
            TypeToken<?> defaultType = NullPointerTester.getFirstTypeParameter(type.getType());
            return (T)defaultType;
        }
        if (type.getRawType().isInterface()) {
            return this.newDefaultReturningProxy(type);
        }
        return null;
    }

    private static TypeToken<?> getFirstTypeParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.of((Type)((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        return TypeToken.of(Object.class);
    }

    private <T> T newDefaultReturningProxy(TypeToken<T> type) {
        return new DummyProxy(){

            @Override
            <R> R dummyReturnValue(TypeToken<R> returnType) {
                return (R)NullPointerTester.this.getDefaultValue(returnType);
            }
        }.newProxy(type);
    }

    private static Invokable<?, ?> invokable(@Nullable Object instance, Method method) {
        if (instance == null) {
            return Invokable.from((Method)method);
        }
        return TypeToken.of(instance.getClass()).method(method);
    }

    static boolean isPrimitiveOrNullable(Parameter param) {
        return param.getType().getRawType().isPrimitive() || param.isAnnotationPresent(Nullable.class);
    }

    private boolean isIgnored(Member member) {
        return member.isSynthetic() || this.ignoredMembers.contains(member);
    }

    private static final class Signature {
        private final String name;
        private final ImmutableList<Class<?>> parameterTypes;

        Signature(Method method) {
            this(method.getName(), ImmutableList.copyOf((Object[])method.getParameterTypes()));
        }

        Signature(String name, ImmutableList<Class<?>> parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature that = (Signature)obj;
                return this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.parameterTypes});
        }
    }

    public static enum Visibility {
        PACKAGE{

            @Override
            boolean isVisible(int modifiers) {
                return !Modifier.isPrivate(modifiers);
            }
        }
        ,
        PROTECTED{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }
        }
        ,
        PUBLIC{

            @Override
            boolean isVisible(int modifiers) {
                return Modifier.isPublic(modifiers);
            }
        };


        abstract boolean isVisible(int var1);

        final boolean isVisible(Member member) {
            return this.isVisible(member.getModifiers());
        }

        final Iterable<Method> getStaticMethods(Class<?> cls) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Method method : this.getVisibleMethods(cls)) {
                if (!Invokable.from((Method)method).isStatic()) continue;
                builder.add((Object)method);
            }
            return builder.build();
        }

        final Iterable<Method> getInstanceMethods(Class<?> cls) {
            ConcurrentMap map = Maps.newConcurrentMap();
            for (Method method : this.getVisibleMethods(cls)) {
                if (Invokable.from((Method)method).isStatic()) continue;
                map.putIfAbsent(new Signature(method), method);
            }
            return map.values();
        }

        private ImmutableList<Method> getVisibleMethods(Class<?> cls) {
            Class type;
            String visiblePackage = Reflection.getPackageName(cls);
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator i$ = TypeToken.of(cls).getTypes().classes().rawTypes().iterator();
            while (i$.hasNext() && Reflection.getPackageName((Class)(type = (Class)i$.next())).equals(visiblePackage)) {
                for (Method method : type.getDeclaredMethods()) {
                    if (method.isSynthetic() || !this.isVisible(method)) continue;
                    builder.add((Object)method);
                }
            }
            return builder.build();
        }
    }
}

