/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class SetMultimapPutTester<K, V>
extends AbstractMultimapTester<K, V, SetMultimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutDuplicateValue() {
        List<Map.Entry> entries = Helpers.copyToList(((SetMultimap)this.multimap()).entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Set values = ((SetMultimap)this.multimap()).get(k);
            Set expectedValues = Helpers.copyToSet(values);
            SetMultimapPutTester.assertFalse((boolean)((SetMultimap)this.multimap()).put(k, v));
            SetMultimapPutTester.assertEquals(expectedValues, (Object)values);
            this.assertGet(k, expectedValues);
        }
    }
}

