/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public class MultimapReplaceValuesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceEmptyValues() {
        int size = this.multimap().size();
        Object key = this.sampleKeys().e3;
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e2, this.sampleValues().e3);
        this.multimap().replaceValues(key, values);
        this.assertGet(key, values);
        MultimapReplaceValuesTester.assertEquals((int)(size + values.size()), (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceNonEmptyValues() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e2, this.sampleValues().e3);
        for (Object k : keys) {
            this.resetContainer();
            int size = this.multimap().size();
            List oldKeyValues = Helpers.copyToList(this.multimap().get(k));
            this.multimap().replaceValues(k, values);
            this.assertGet(k, values);
            MultimapReplaceValuesTester.assertEquals((int)(size + values.size() - oldKeyValues.size()), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceValuesRemoveNotSupported() {
        List values = Collections.singletonList(this.sampleValues().e3);
        try {
            this.multimap().replaceValues(this.sampleKeys().e0, values);
            MultimapReplaceValuesTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testReplaceValuesPutNotSupported() {
        List values = Collections.singletonList(this.sampleValues().e3);
        try {
            this.multimap().replaceValues(this.sampleKeys().e0, values);
            MultimapReplaceValuesTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

