/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Beta
public final class TestingExecutors {
    private TestingExecutors() {
    }

    public static ListeningScheduledExecutorService noOpScheduledExecutor() {
        return new NoOpScheduledExecutorService();
    }

    private static final class NoOpScheduledExecutorService
    extends AbstractListeningExecutorService
    implements ListeningScheduledExecutorService {
        private volatile boolean shutdown;

        private NoOpScheduledExecutorService() {
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public List<Runnable> shutdownNow() {
            this.shutdown();
            return ImmutableList.of();
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public boolean isTerminated() {
            return this.shutdown;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        public void execute(Runnable runnable) {
        }

        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        private static class NeverScheduledFuture<V>
        extends AbstractFuture<V>
        implements ScheduledFuture<V> {
            private NeverScheduledFuture() {
            }

            static <V> NeverScheduledFuture<V> create() {
                return new NeverScheduledFuture<V>();
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return Long.MAX_VALUE;
            }

            @Override
            public int compareTo(Delayed other) {
                return Longs.compare((long)this.getDelay(TimeUnit.NANOSECONDS), (long)other.getDelay(TimeUnit.NANOSECONDS));
            }
        }
    }
}

