/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;

@GwtCompatible
public class MultimapContainsEntryTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsEntryYes() {
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
    }

    public void testContainsEntryNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(this.sampleKeys().e3, this.sampleValues().e3));
    }

    public void testContainsEntryAgreesWithGet() {
        for (Object k : this.sampleKeys()) {
            for (Object v : this.sampleValues()) {
                MultimapContainsEntryTester.assertEquals((boolean)this.multimap().get(k).contains(v), (boolean)this.multimap().containsEntry(k, v));
            }
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryNullYes() {
        this.initMultimapWithNullKeyAndValue();
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContainsEntryNullNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContainsEntryNullDisallowed() {
        try {
            this.multimap().containsEntry(null, null);
            MultimapContainsEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

