/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SafeTreeSet<E>
implements Serializable,
NavigableSet<E> {
    private static final Comparator NATURAL_ORDER = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    private final NavigableSet<E> delegate;
    private static final long serialVersionUID = 0L;

    public SafeTreeSet() {
        this(new TreeSet());
    }

    public SafeTreeSet(Collection<? extends E> collection) {
        this((NavigableSet<? extends E>)new TreeSet<E>(collection));
    }

    public SafeTreeSet(Comparator<? super E> comparator) {
        this((NavigableSet<? super E>)new TreeSet<E>(comparator));
    }

    public SafeTreeSet(SortedSet<E> set) {
        this(new TreeSet<E>(set));
    }

    private SafeTreeSet(NavigableSet<E> delegate) {
        this.delegate = delegate;
        for (E e : this) {
            this.checkValid(e);
        }
    }

    @Override
    public boolean add(E element) {
        return this.delegate.add(this.checkValid(element));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E e : collection) {
            this.checkValid(e);
        }
        return this.delegate.addAll(collection);
    }

    @Override
    public E ceiling(E e) {
        return this.delegate.ceiling(this.checkValid(e));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        Comparator comparator = this.delegate.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return comparator;
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(this.checkValid(object));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.delegate.descendingIterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new SafeTreeSet<E>(this.delegate.descendingSet());
    }

    @Override
    public E first() {
        return this.delegate.first();
    }

    @Override
    public E floor(E e) {
        return this.delegate.floor(this.checkValid(e));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new SafeTreeSet<E>(this.delegate.headSet(this.checkValid(toElement), inclusive));
    }

    @Override
    public E higher(E e) {
        return this.delegate.higher(this.checkValid(e));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public E last() {
        return this.delegate.last();
    }

    @Override
    public E lower(E e) {
        return this.delegate.lower(this.checkValid(e));
    }

    @Override
    public E pollFirst() {
        return this.delegate.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.delegate.pollLast();
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate.remove(this.checkValid(object));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new SafeTreeSet<E>(this.delegate.subSet(this.checkValid(fromElement), fromInclusive, this.checkValid(toElement), toInclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new SafeTreeSet<E>(this.delegate.tailSet(this.checkValid(fromElement), inclusive));
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    private <T> T checkValid(T t) {
        T e = t;
        this.comparator().compare(e, e);
        return t;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

