/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.testing.RelationshipTester;
import java.util.List;
import junit.framework.Assert;

@Beta
@GwtCompatible
public final class EqualsTester {
    private static final int REPETITIONS = 3;
    private final List<List<Object>> equalityGroups = Lists.newArrayList();
    private RelationshipTester.ItemReporter itemReporter = new RelationshipTester.ItemReporter();

    public EqualsTester addEqualityGroup(Object ... equalityGroup) {
        Preconditions.checkNotNull((Object)equalityGroup);
        this.equalityGroups.add((List<Object>)ImmutableList.copyOf((Object[])equalityGroup));
        return this;
    }

    public EqualsTester testEquals() {
        RelationshipTester<Object> delegate = new RelationshipTester<Object>(new RelationshipTester.RelationshipAssertion<Object>(){

            @Override
            public void assertRelated(Object item, Object related) {
                Assert.assertEquals((String)"$ITEM must be Object#equals to $RELATED", (Object)item, (Object)related);
                int itemHash = item.hashCode();
                int relatedHash = related.hashCode();
                Assert.assertEquals((String)("the Object#hashCode (" + itemHash + ") of $ITEM must be equal to the " + "Object#hashCode (" + relatedHash + ") of $RELATED"), (int)itemHash, (int)relatedHash);
            }

            @Override
            public void assertUnrelated(Object item, Object unrelated) {
                Assert.assertTrue((String)"$ITEM must not be Object#equals to $UNRELATED", (!Objects.equal((Object)item, (Object)unrelated) ? 1 : 0) != 0);
            }
        }, this.itemReporter);
        for (List<Object> group : this.equalityGroups) {
            delegate.addRelatedGroup(group);
        }
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            delegate.test();
        }
        return this;
    }

    EqualsTester setItemReporter(RelationshipTester.ItemReporter reporter) {
        this.itemReporter = (RelationshipTester.ItemReporter)Preconditions.checkNotNull((Object)reporter);
        return this;
    }

    private void testItems() {
        for (Object item : Iterables.concat(this.equalityGroups)) {
            Assert.assertTrue((String)(item + " must not be Object#equals to null"), (!item.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)(item + " must not be Object#equals to an arbitrary object of another class"), (!item.equals((Object)NotAnInstance.EQUAL_TO_NOTHING) ? 1 : 0) != 0);
            Assert.assertEquals((String)(item + " must be Object#equals to itself"), item, item);
            Assert.assertEquals((String)("the Object#hashCode of " + item + " must be consistent"), (int)item.hashCode(), (int)item.hashCode());
        }
    }

    private static enum NotAnInstance {
        EQUAL_TO_NOTHING;

    }
}

