/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Collections;
import org.truth0.Truth;

@GwtCompatible
public class MultimapGetTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testGetEmpty() {
        Collection result = this.multimap().get(this.sampleKeys().e3);
        MultimapGetTester.assertTrue((boolean)result.isEmpty());
        MultimapGetTester.assertEquals((int)0, (int)result.size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetNonEmpty() {
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapGetTester.assertFalse((boolean)result.isEmpty());
        Helpers.assertContentsAnyOrder(result, this.sampleValues().e0);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testGetMultiple() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e2));
        this.assertGet(this.sampleKeys().e0, this.sampleValues().e0, this.sampleValues().e1, this.sampleValues().e2);
    }

    public void testGetAbsentKey() {
        this.assertGet(this.sampleKeys().e4, new Object[0]);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e2));
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapGetTester.assertTrue((boolean)result.remove(this.sampleValues().e0));
        MultimapGetTester.assertFalse((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
        MultimapGetTester.assertEquals((int)2, (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveLastElementToMultimap() {
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapGetTester.assertTrue((boolean)result.remove(this.sampleValues().e0));
        this.assertGet(this.sampleKeys().e0, new Object[0]);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddToMultimap() {
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapGetTester.assertTrue((boolean)result.add(this.sampleValues().e3));
        MultimapGetTester.assertTrue((boolean)this.multimap().containsKey(this.sampleKeys().e0));
        MultimapGetTester.assertEquals((int)(this.getNumElements() + 1), (int)this.multimap().size());
        MultimapGetTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e3));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddAllToMultimap() {
        Collection result = this.multimap().get(this.sampleKeys().e0);
        MultimapGetTester.assertTrue((boolean)result.addAll(Collections.singletonList(this.sampleValues().e3)));
        MultimapGetTester.assertTrue((boolean)this.multimap().containsKey(this.sampleKeys().e0));
        MultimapGetTester.assertEquals((int)(this.getNumElements() + 1), (int)this.multimap().size());
        MultimapGetTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e3));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.SUPPORTS_PUT})
    public void testPropagatesRemoveLastThenAddToMultimap() {
        int oldSize = this.getNumElements();
        Object k0 = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Collection result = this.multimap().get(k0);
        MultimapGetTester.assertTrue((boolean)result.remove(v0));
        MultimapGetTester.assertFalse((boolean)this.multimap().containsKey(k0));
        MultimapGetTester.assertFalse((boolean)this.multimap().containsEntry(k0, v0));
        Truth.ASSERT.that(result).isEmpty();
        Object v1 = this.sampleValues().e1;
        Object v2 = this.sampleValues().e2;
        MultimapGetTester.assertTrue((boolean)result.add(v1));
        MultimapGetTester.assertTrue((boolean)result.add(v2));
        Truth.ASSERT.that(result).has().exactly(v1, v2, new Object[0]);
        Truth.ASSERT.that(this.multimap().get(k0)).has().exactly(v1, v2, new Object[0]);
        MultimapGetTester.assertTrue((boolean)this.multimap().containsKey(k0));
        MultimapGetTester.assertFalse((boolean)this.multimap().containsEntry(k0, v0));
        MultimapGetTester.assertTrue((boolean)this.multimap().containsEntry(k0, v2));
        MultimapGetTester.assertEquals((int)(oldSize + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetNullPresent() {
        this.initMultimapWithNullKey();
        Truth.ASSERT.that(this.multimap().get(null)).has().item(this.getValueForNullKey());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_QUERIES})
    public void testGetNullAbsent() {
        Truth.ASSERT.that(this.multimap().get(null)).isEmpty();
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testGetNullForbidden() {
        try {
            this.multimap().get(null);
            MultimapGetTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetWithNullValue() {
        this.initMultimapWithNullValue();
        Truth.ASSERT.that(this.multimap().get(this.getKeyForNullValue())).has().item(null);
    }
}

