/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.truth0.Truth;

@GwtCompatible
public class MultimapAsMapTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testAsMapGet() {
        for (Object key : this.sampleKeys()) {
            ArrayList expectedValues = new ArrayList();
            for (Map.Entry entry : this.getSampleElements()) {
                if (!entry.getKey().equals(key)) continue;
                expectedValues.add(entry.getValue());
            }
            Collection collection = (Collection)this.multimap().asMap().get(key);
            if (expectedValues.isEmpty()) {
                Truth.ASSERT.that(collection).isNull();
                continue;
            }
            Truth.ASSERT.that(collection).has().exactlyAs(expectedValues);
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testAsMapGetNullKeyPresent() {
        this.initMultimapWithNullKey();
        Truth.ASSERT.that((Collection)this.multimap().asMap().get(null)).has().exactly(this.getValueForNullKey());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testAsMapGetNullKeyAbsent() {
        Truth.ASSERT.that((Collection)this.multimap().asMap().get(null)).isNull();
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testAsMapGetNullKeyUnsupported() {
        try {
            this.multimap().asMap().get(null);
            MultimapAsMapTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testAsMapRemove() {
        Truth.ASSERT.that((Collection)this.multimap().asMap().remove(this.sampleKeys().e0)).iteratesAs(new Object[]{this.sampleValues().e0});
        this.assertGet(this.sampleKeys().e0, new Object[0]);
        MultimapAsMapTester.assertEquals((int)(this.getNumElements() - 1), (int)this.multimap().size());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testAsMapEntrySetReflectsPutSameKey() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Collection valueCollection = (Collection)((Map.Entry)Iterables.getOnlyElement(asMapEntrySet)).getValue();
        Truth.ASSERT.that(valueCollection).has().exactly(this.sampleValues().e0, this.sampleValues().e3, new Object[0]);
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.sampleKeys().e0, this.sampleValues().e4));
        Truth.ASSERT.that(valueCollection).has().exactly(this.sampleValues().e0, this.sampleValues().e3, new Object[]{this.sampleValues().e4});
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testAsMapEntrySetReflectsPutDifferentKey() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.sampleKeys().e1, this.sampleValues().e4));
        MultimapAsMapTester.assertEquals((int)2, (int)asMapEntrySet.size());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testAsMapEntrySetRemovePropagatesToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Map.Entry asMapEntry0 = (Map.Entry)Iterables.getOnlyElement(asMapEntrySet);
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.sampleKeys().e1, this.sampleValues().e4));
        MultimapAsMapTester.assertTrue((boolean)asMapEntrySet.remove(asMapEntry0));
        MultimapAsMapTester.assertEquals((int)1, (int)this.multimap().size());
        Truth.ASSERT.that((Collection)this.multimap().keySet()).iteratesAs(new Object[]{this.sampleKeys().e1});
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testAsMapEntrySetIteratorRemovePropagatesToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Iterator asMapEntryItr = asMapEntrySet.iterator();
        asMapEntryItr.next();
        asMapEntryItr.remove();
        MultimapAsMapTester.assertTrue((boolean)this.multimap().isEmpty());
    }
}

