/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractListMultimapTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@GwtCompatible
public class ListMultimapRemoveTester<K, V>
extends AbstractListMultimapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testMultimapRemoveDeletesFirstOccurrence() {
        Object k = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Object v1 = this.sampleValues().e2;
        this.resetContainer(Helpers.mapEntry(k, v0), Helpers.mapEntry(k, v1), Helpers.mapEntry(k, v0));
        List list = ((ListMultimap)this.multimap()).get(k);
        ((ListMultimap)this.multimap()).remove(k, v0);
        Truth.assertThat((List)list).has().exactly(v1, v0, new Object[0]).inOrder();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromGetPropagates() {
        Object k = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Object v1 = this.sampleValues().e2;
        List<Object> values = Arrays.asList(v0, v1, v0);
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(k, v0), Helpers.mapEntry(k, v1), Helpers.mapEntry(k, v0));
            List<Object> expectedValues = Helpers.copyToList(values);
            ((ListMultimap)this.multimap()).get(k).remove(i);
            expectedValues.remove(i);
            this.assertGet(k, expectedValues);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromAsMapPropagates() {
        Object k = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Object v1 = this.sampleValues().e2;
        List<Object> values = Arrays.asList(v0, v1, v0);
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(k, v0), Helpers.mapEntry(k, v1), Helpers.mapEntry(k, v0));
            List<Object> expectedValues = Helpers.copyToList(values);
            List asMapValue = (List)((ListMultimap)this.multimap()).asMap().get(k);
            asMapValue.remove(i);
            expectedValues.remove(i);
            this.assertGet(k, expectedValues);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromAsMapEntrySetPropagates() {
        Object k = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Object v1 = this.sampleValues().e2;
        List<Object> values = Arrays.asList(v0, v1, v0);
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(k, v0), Helpers.mapEntry(k, v1), Helpers.mapEntry(k, v0));
            List<Object> expectedValues = Helpers.copyToList(values);
            Map.Entry asMapEntry = ((ListMultimap)this.multimap()).asMap().entrySet().iterator().next();
            List asMapValue = (List)asMapEntry.getValue();
            asMapValue.remove(i);
            expectedValues.remove(i);
            this.assertGet(k, expectedValues);
        }
    }
}

