/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class FreshValueGenerator {
    private static final ImmutableMap<Class<?>, Method> GENERATORS;
    private final AtomicInteger differentiator = new AtomicInteger(1);
    private final ListMultimap<Class<?>, Object> sampleInstances = ArrayListMultimap.create();
    private final Set<Type> generatedOptionalTypes = Sets.newHashSet();

    FreshValueGenerator() {
    }

    <T> void addSampleInstances(Class<T> type, Iterable<? extends T> instances) {
        this.sampleInstances.putAll(Preconditions.checkNotNull(type), (Iterable)Preconditions.checkNotNull(instances));
    }

    @Nullable
    Object generate(TypeToken<?> type) {
        Class rawType = type.getRawType();
        List samples = this.sampleInstances.get((Object)rawType);
        Object sample = this.nextInstance(samples, null);
        if (sample != null) {
            return sample;
        }
        if (rawType.isEnum()) {
            return this.nextInstance(rawType.getEnumConstants(), null);
        }
        if (type.isArray()) {
            TypeToken componentType = type.getComponentType();
            Object array = Array.newInstance(componentType.getRawType(), 1);
            Array.set(array, 0, this.generate(componentType));
            return array;
        }
        if (rawType == Optional.class && this.generatedOptionalTypes.add(type.getType())) {
            return Optional.absent();
        }
        Method generator = (Method)GENERATORS.get((Object)rawType);
        if (generator != null) {
            ImmutableList params = Invokable.from((Method)generator).getParameters();
            ArrayList args = Lists.newArrayListWithCapacity((int)params.size());
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < params.size(); ++i) {
                TypeToken paramType = type.resolveType(typeVars[i]);
                Object argValue = this.generate(paramType);
                if (argValue == null) {
                    return null;
                }
                args.add(argValue);
            }
            try {
                return generator.invoke((Object)this, args.toArray());
            }
            catch (InvocationTargetException e) {
                Throwables.propagate((Throwable)e.getCause());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return this.defaultGenerate(rawType);
    }

    @Nullable
    final <T> T generate(Class<T> type) {
        return Primitives.wrap(type).cast(this.generate(TypeToken.of(type)));
    }

    private <T> T defaultGenerate(Class<T> rawType) {
        if (rawType.isInterface()) {
            return this.newProxy(rawType);
        }
        return ArbitraryInstances.get(rawType);
    }

    final <T> T newProxy(Class<T> interfaceType) {
        return (T)Reflection.newProxy(interfaceType, (InvocationHandler)((Object)new FreshInvocationHandler(interfaceType)));
    }

    Object interfaceMethodCalled(Class<?> interfaceType, Method method) {
        throw new UnsupportedOperationException();
    }

    private <T> T nextInstance(T[] instances, T defaultValue) {
        return this.nextInstance(Arrays.asList(instances), defaultValue);
    }

    private <T> T nextInstance(Collection<T> instances, T defaultValue) {
        if (instances.isEmpty()) {
            return defaultValue;
        }
        return (T)Iterables.get(instances, (int)((this.freshInt() - 1) % instances.size()));
    }

    private static String paramString(Class<?> type, int i) {
        String string = String.valueOf(String.valueOf(type.getSimpleName()));
        int n = i;
        return new StringBuilder(12 + string.length()).append(string).append("@").append(n).toString();
    }

    @Generates
    private Class<?> freshClass() {
        return this.nextInstance((Collection)ImmutableList.of(Integer.TYPE, Long.TYPE, Void.TYPE, Object.class, Object[].class, Iterable.class), (Object)Object.class);
    }

    @Generates
    private Object freshObject() {
        return this.freshString();
    }

    @Generates
    private Number freshNumber() {
        return this.freshInt();
    }

    @Generates
    private int freshInt() {
        return this.differentiator.getAndIncrement();
    }

    @Generates
    private Integer freshInteger() {
        return new Integer(this.freshInt());
    }

    @Generates
    private long freshLong() {
        return this.freshInt();
    }

    @Generates
    private Long freshLongObject() {
        return new Long(this.freshLong());
    }

    @Generates
    private float freshFloat() {
        return this.freshInt();
    }

    @Generates
    private Float freshFloatObject() {
        return new Float(this.freshFloat());
    }

    @Generates
    private double freshDouble() {
        return this.freshInt();
    }

    @Generates
    private Double freshDoubleObject() {
        return new Double(this.freshDouble());
    }

    @Generates
    private short freshShort() {
        return (short)this.freshInt();
    }

    @Generates
    private Short freshShortObject() {
        return new Short(this.freshShort());
    }

    @Generates
    private byte freshByte() {
        return (byte)this.freshInt();
    }

    @Generates
    private Byte freshByteObject() {
        return new Byte(this.freshByte());
    }

    @Generates
    private char freshChar() {
        return this.freshString().charAt(0);
    }

    @Generates
    private Character freshCharacter() {
        return new Character(this.freshChar());
    }

    @Generates
    private boolean freshBoolean() {
        return this.freshInt() % 2 == 0;
    }

    @Generates
    private Boolean freshBooleanObject() {
        return new Boolean(this.freshBoolean());
    }

    @Generates
    private UnsignedInteger freshUnsignedInteger() {
        return UnsignedInteger.fromIntBits((int)this.freshInt());
    }

    @Generates
    private UnsignedLong freshUnsignedLong() {
        return UnsignedLong.fromLongBits((long)this.freshLong());
    }

    @Generates
    private BigInteger freshBigInteger() {
        return BigInteger.valueOf(this.freshInt());
    }

    @Generates
    private BigDecimal freshBigDecimal() {
        return BigDecimal.valueOf(this.freshInt());
    }

    @Generates
    private CharSequence freshCharSequence() {
        return this.freshString();
    }

    @Generates
    private String freshString() {
        return Integer.toString(this.freshInt());
    }

    @Generates
    private Comparable<?> freshComparable() {
        return this.freshString();
    }

    @Generates
    private Pattern freshPattern() {
        return Pattern.compile(this.freshString());
    }

    @Generates
    private Charset freshCharset() {
        return this.nextInstance(Charset.availableCharsets().values(), Charsets.UTF_8);
    }

    @Generates
    private Locale freshLocale() {
        return this.nextInstance(Locale.getAvailableLocales(), Locale.US);
    }

    @Generates
    private Currency freshCurrency() {
        HashSet uselessLocales = Sets.newHashSet();
        Locale locale;
        while (!uselessLocales.contains(locale = this.freshLocale())) {
            try {
                return Currency.getInstance(locale);
            }
            catch (IllegalArgumentException e) {
                uselessLocales.add(locale);
                continue;
            }
            break;
        }
        return Currency.getInstance(Locale.US);
    }

    @Generates
    private <T> Optional<T> freshOptional(T value) {
        return Optional.of(value);
    }

    @Generates
    private Joiner freshJoiner() {
        return Joiner.on((String)this.freshString());
    }

    @Generates
    private Splitter freshSplitter() {
        return Splitter.on((String)this.freshString());
    }

    @Generates
    private <T> Equivalence<T> freshEquivalence() {
        return new Equivalence<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Equivalence.class, FreshValueGenerator.this.freshInt());
            }

            protected boolean doEquivalent(T a, T b) {
                return false;
            }

            protected int doHash(T t) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private CharMatcher freshCharMatcher() {
        return new CharMatcher(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(CharMatcher.class, FreshValueGenerator.this.freshInt());
            }

            public boolean matches(char c) {
                return false;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private Ticker freshTicker() {
        return new Ticker(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ticker.class, FreshValueGenerator.this.freshInt());
            }

            public long read() {
                return 0L;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private <T> Comparator<T> freshComparator() {
        return this.freshOrdering();
    }

    @Generates
    private <T> Ordering<T> freshOrdering() {
        return new Ordering<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ordering.class, FreshValueGenerator.this.freshInt());
            }

            public int compare(T left, T right) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private static <C extends Comparable> Range<C> freshRange(C freshElement) {
        return Range.singleton(freshElement);
    }

    @Generates
    private static <E> Iterable<E> freshIterable(E freshElement) {
        return FreshValueGenerator.freshList(freshElement);
    }

    @Generates
    private static <E> Collection<E> freshCollection(E freshElement) {
        return FreshValueGenerator.freshList(freshElement);
    }

    @Generates
    private static <E> List<E> freshList(E freshElement) {
        return FreshValueGenerator.freshArrayList(freshElement);
    }

    @Generates
    private static <E> ArrayList<E> freshArrayList(E freshElement) {
        ArrayList list = Lists.newArrayList();
        list.add(freshElement);
        return list;
    }

    @Generates
    private static <E> LinkedList<E> freshLinkedList(E freshElement) {
        LinkedList list = Lists.newLinkedList();
        list.add(freshElement);
        return list;
    }

    @Generates
    private static <E> ImmutableList<E> freshImmutableList(E freshElement) {
        return ImmutableList.of(freshElement);
    }

    @Generates
    private static <E> ImmutableCollection<E> freshImmutableCollection(E freshElement) {
        return FreshValueGenerator.freshImmutableList(freshElement);
    }

    @Generates
    private static <E> Set<E> freshSet(E freshElement) {
        return FreshValueGenerator.freshHashSet(freshElement);
    }

    @Generates
    private static <E> HashSet<E> freshHashSet(E freshElement) {
        return FreshValueGenerator.freshLinkedHashSet(freshElement);
    }

    @Generates
    private static <E> LinkedHashSet<E> freshLinkedHashSet(E freshElement) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    private static <E> ImmutableSet<E> freshImmutableSet(E freshElement) {
        return ImmutableSet.of(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> SortedSet<E> freshSortedSet(E freshElement) {
        return FreshValueGenerator.freshNavigableSet(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> NavigableSet<E> freshNavigableSet(E freshElement) {
        return FreshValueGenerator.freshTreeSet(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> TreeSet<E> freshTreeSet(E freshElement) {
        TreeSet set = Sets.newTreeSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    private static <E extends Comparable<? super E>> ImmutableSortedSet<E> freshImmutableSortedSet(E freshElement) {
        return ImmutableSortedSet.of(freshElement);
    }

    @Generates
    private static <E> Multiset<E> freshMultiset(E freshElement) {
        return FreshValueGenerator.freshHashMultiset(freshElement);
    }

    @Generates
    private static <E> HashMultiset<E> freshHashMultiset(E freshElement) {
        HashMultiset multiset = HashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E> LinkedHashMultiset<E> freshLinkedHashMultiset(E freshElement) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E> ImmutableMultiset<E> freshImmutableMultiset(E freshElement) {
        return ImmutableMultiset.of(freshElement);
    }

    @Generates
    private static <E extends Comparable<E>> SortedMultiset<E> freshSortedMultiset(E freshElement) {
        return FreshValueGenerator.freshTreeMultiset(freshElement);
    }

    @Generates
    private static <E extends Comparable<E>> TreeMultiset<E> freshTreeMultiset(E freshElement) {
        TreeMultiset multiset = TreeMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E extends Comparable<E>> ImmutableSortedMultiset<E> freshImmutableSortedMultiset(E freshElement) {
        return ImmutableSortedMultiset.of(freshElement);
    }

    @Generates
    private static <K, V> Map<K, V> freshMap(K key, V value) {
        return FreshValueGenerator.freshHashdMap(key, value);
    }

    @Generates
    private static <K, V> HashMap<K, V> freshHashdMap(K key, V value) {
        return FreshValueGenerator.freshLinkedHashMap(key, value);
    }

    @Generates
    private static <K, V> LinkedHashMap<K, V> freshLinkedHashMap(K key, V value) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K, V> ImmutableMap<K, V> freshImmutableMap(K key, V value) {
        return ImmutableMap.of(key, value);
    }

    @Generates
    private static <K, V> ConcurrentMap<K, V> freshConcurrentMap(K key, V value) {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K extends Comparable<? super K>, V> SortedMap<K, V> freshSortedMap(K key, V value) {
        return FreshValueGenerator.freshNavigableMap(key, value);
    }

    @Generates
    private static <K extends Comparable<? super K>, V> NavigableMap<K, V> freshNavigableMap(K key, V value) {
        return FreshValueGenerator.freshTreeMap(key, value);
    }

    @Generates
    private static <K extends Comparable<? super K>, V> TreeMap<K, V> freshTreeMap(K key, V value) {
        TreeMap map = Maps.newTreeMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> freshImmutableSortedMap(K key, V value) {
        return ImmutableSortedMap.of(key, value);
    }

    @Generates
    private static <K, V> Multimap<K, V> freshMultimap(K key, V value) {
        return FreshValueGenerator.freshListMultimap(key, value);
    }

    @Generates
    private static <K, V> ImmutableMultimap<K, V> freshImmutableMultimap(K key, V value) {
        return ImmutableMultimap.of(key, value);
    }

    @Generates
    private static <K, V> ListMultimap<K, V> freshListMultimap(K key, V value) {
        return FreshValueGenerator.freshArrayListMultimap(key, value);
    }

    @Generates
    private static <K, V> ArrayListMultimap<K, V> freshArrayListMultimap(K key, V value) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> ImmutableListMultimap<K, V> freshImmutableListMultimap(K key, V value) {
        return ImmutableListMultimap.of(key, value);
    }

    @Generates
    private static <K, V> SetMultimap<K, V> freshSetMultimap(K key, V value) {
        return FreshValueGenerator.freshLinkedHashMultimap(key, value);
    }

    @Generates
    private static <K, V> HashMultimap<K, V> freshHashMultimap(K key, V value) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> LinkedHashMultimap<K, V> freshLinkedHashMultimap(K key, V value) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> ImmutableSetMultimap<K, V> freshImmutableSetMultimap(K key, V value) {
        return ImmutableSetMultimap.of(key, value);
    }

    @Generates
    private static <K, V> BiMap<K, V> freshBimap(K key, V value) {
        return FreshValueGenerator.freshHashBiMap(key, value);
    }

    @Generates
    private static <K, V> HashBiMap<K, V> freshHashBiMap(K key, V value) {
        HashBiMap bimap = HashBiMap.create();
        bimap.put(key, value);
        return bimap;
    }

    @Generates
    private static <K, V> ImmutableBiMap<K, V> freshImmutableBimap(K key, V value) {
        return ImmutableBiMap.of(key, value);
    }

    @Generates
    private static <R, C, V> Table<R, C, V> freshTable(R row, C column, V value) {
        return FreshValueGenerator.freshHashBasedTable(row, column, value);
    }

    @Generates
    private static <R, C, V> HashBasedTable<R, C, V> freshHashBasedTable(R row, C column, V value) {
        HashBasedTable table = HashBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    private static <R extends Comparable, C extends Comparable, V> RowSortedTable<R, C, V> freshRowSortedTable(R row, C column, V value) {
        return FreshValueGenerator.freshTreeBasedTable(row, column, value);
    }

    @Generates
    private static <R extends Comparable, C extends Comparable, V> TreeBasedTable<R, C, V> freshTreeBasedTable(R row, C column, V value) {
        TreeBasedTable table = TreeBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    private static <R, C, V> ImmutableTable<R, C, V> freshImmutableTable(R row, C column, V value) {
        return ImmutableTable.of(row, column, value);
    }

    @Generates
    private TypeToken<?> freshTypeToken() {
        return TypeToken.of(this.freshClass());
    }

    @Generates
    private File freshFile() {
        return new File(this.freshString());
    }

    @Generates
    private static ByteArrayInputStream freshByteArrayInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Generates
    private static InputStream freshInputStream() {
        return FreshValueGenerator.freshByteArrayInputStream();
    }

    @Generates
    private StringReader freshStringReader() {
        return new StringReader(this.freshString());
    }

    @Generates
    private Reader freshReader() {
        return this.freshStringReader();
    }

    @Generates
    private Readable freshReadable() {
        return this.freshReader();
    }

    @Generates
    private Buffer freshBuffer() {
        return this.freshCharBuffer();
    }

    @Generates
    private CharBuffer freshCharBuffer() {
        return CharBuffer.allocate(this.freshInt());
    }

    @Generates
    private ByteBuffer freshByteBuffer() {
        return ByteBuffer.allocate(this.freshInt());
    }

    @Generates
    private ShortBuffer freshShortBuffer() {
        return ShortBuffer.allocate(this.freshInt());
    }

    @Generates
    private IntBuffer freshIntBuffer() {
        return IntBuffer.allocate(this.freshInt());
    }

    @Generates
    private LongBuffer freshLongBuffer() {
        return LongBuffer.allocate(this.freshInt());
    }

    @Generates
    private FloatBuffer freshFloatBuffer() {
        return FloatBuffer.allocate(this.freshInt());
    }

    @Generates
    private DoubleBuffer freshDoubleBuffer() {
        return DoubleBuffer.allocate(this.freshInt());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : FreshValueGenerator.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Generates.class)) continue;
            builder.put(method.getReturnType(), (Object)method);
        }
        GENERATORS = builder.build();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Generates {
    }

    private final class FreshInvocationHandler
    extends AbstractInvocationHandler {
        private final int identity;
        private final Class<?> interfaceType;

        FreshInvocationHandler(Class<?> interfaceType) {
            this.identity = FreshValueGenerator.this.freshInt();
            this.interfaceType = interfaceType;
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) {
            return FreshValueGenerator.this.interfaceMethodCalled(this.interfaceType, method);
        }

        public int hashCode() {
            return this.identity;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof FreshInvocationHandler) {
                FreshInvocationHandler that = (FreshInvocationHandler)((Object)obj);
                return this.identity == that.identity;
            }
            return false;
        }

        public String toString() {
            return FreshValueGenerator.paramString(this.interfaceType, this.identity);
        }
    }
}

