/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.RelationshipTester;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;

@Beta
@GwtCompatible
public final class EquivalenceTester<T> {
    private static final int REPETITIONS = 3;
    private final Equivalence<? super T> equivalence;
    private final RelationshipTester<T> delegate;
    private final List<T> items = Lists.newArrayList();

    private EquivalenceTester(Equivalence<? super T> equivalence) {
        this.equivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.delegate = new RelationshipTester<T>(equivalence, "equivalent", "hash", new RelationshipTester.ItemReporter());
    }

    public static <T> EquivalenceTester<T> of(Equivalence<? super T> equivalence) {
        return new EquivalenceTester<T>(equivalence);
    }

    public EquivalenceTester<T> addEquivalenceGroup(T first, T ... rest) {
        this.addEquivalenceGroup(Lists.asList(first, (Object[])rest));
        return this;
    }

    public EquivalenceTester<T> addEquivalenceGroup(Iterable<T> group) {
        this.delegate.addRelatedGroup(group);
        this.items.addAll((Collection<T>)ImmutableList.copyOf(group));
        return this;
    }

    public EquivalenceTester<T> test() {
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            this.delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (T item : this.items) {
            String string = String.valueOf(String.valueOf(item));
            Assert.assertTrue((String)new StringBuilder(29 + string.length()).append(string).append(" must be inequivalent to null").toString(), (!this.equivalence.equivalent(item, null) ? 1 : 0) != 0);
            String string2 = String.valueOf(String.valueOf(item));
            Assert.assertTrue((String)new StringBuilder(29 + string2.length()).append("null must be inequivalent to ").append(string2).toString(), (!this.equivalence.equivalent(null, item) ? 1 : 0) != 0);
            String string3 = String.valueOf(String.valueOf(item));
            Assert.assertTrue((String)new StringBuilder(29 + string3.length()).append(string3).append(" must be equivalent to itself").toString(), (boolean)this.equivalence.equivalent(item, item));
            String string4 = String.valueOf(String.valueOf(item));
            Assert.assertEquals((String)new StringBuilder(31 + string4.length()).append("the hash of ").append(string4).append(" must be consistent").toString(), (int)this.equivalence.hash(item), (int)this.equivalence.hash(item));
        }
    }
}

