/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

@GwtCompatible
public abstract class MapInterfaceTest<K, V>
extends TestCase {
    protected final boolean supportsPut;
    protected final boolean supportsRemove;
    protected final boolean supportsClear;
    protected final boolean allowsNullKeys;
    protected final boolean allowsNullValues;
    protected final boolean supportsIteratorRemove;

    protected abstract Map<K, V> makeEmptyMap() throws UnsupportedOperationException;

    protected abstract Map<K, V> makePopulatedMap() throws UnsupportedOperationException;

    protected abstract K getKeyNotInPopulatedMap() throws UnsupportedOperationException;

    protected abstract V getValueNotInPopulatedMap() throws UnsupportedOperationException;

    protected MapInterfaceTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear) {
        this(allowsNullKeys, allowsNullValues, supportsPut, supportsRemove, supportsClear, supportsRemove);
    }

    protected MapInterfaceTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
        this.supportsPut = supportsPut;
        this.supportsRemove = supportsRemove;
        this.supportsClear = supportsClear;
        this.allowsNullKeys = allowsNullKeys;
        this.allowsNullValues = allowsNullValues;
        this.supportsIteratorRemove = supportsIteratorRemove;
    }

    protected Map<K, V> makeEitherMap() {
        try {
            return this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return this.makeEmptyMap();
        }
    }

    protected final boolean supportsValuesHashCode(Map<K, V> map) {
        Collection<V> values = map.values();
        for (V value : values) {
            if (value == null) continue;
            try {
                value.hashCode();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return true;
    }

    protected final void assertInvariants(Map<K, V> map) {
        Set<K> keySet = map.keySet();
        Collection<V> valueCollection = map.values();
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        MapInterfaceTest.assertEquals((map.size() == 0 ? 1 : 0) != 0, (boolean)map.isEmpty());
        MapInterfaceTest.assertEquals((int)map.size(), (int)keySet.size());
        MapInterfaceTest.assertEquals((keySet.size() == 0 ? 1 : 0) != 0, (boolean)keySet.isEmpty());
        MapInterfaceTest.assertEquals((!keySet.isEmpty() ? 1 : 0) != 0, (boolean)keySet.iterator().hasNext());
        int expectedKeySetHash = 0;
        for (K key : keySet) {
            V value = map.get(key);
            expectedKeySetHash += key != null ? key.hashCode() : 0;
            MapInterfaceTest.assertTrue((boolean)map.containsKey(key));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(value));
            MapInterfaceTest.assertTrue((boolean)valueCollection.contains(value));
            MapInterfaceTest.assertTrue((boolean)valueCollection.containsAll(Collections.singleton(value)));
            MapInterfaceTest.assertTrue((boolean)entrySet.contains(MapInterfaceTest.mapEntry(key, value)));
            MapInterfaceTest.assertTrue((this.allowsNullKeys || key != null ? 1 : 0) != 0);
        }
        MapInterfaceTest.assertEquals((int)expectedKeySetHash, (int)keySet.hashCode());
        MapInterfaceTest.assertEquals((int)map.size(), (int)valueCollection.size());
        MapInterfaceTest.assertEquals((valueCollection.size() == 0 ? 1 : 0) != 0, (boolean)valueCollection.isEmpty());
        MapInterfaceTest.assertEquals((!valueCollection.isEmpty() ? 1 : 0) != 0, (boolean)valueCollection.iterator().hasNext());
        for (Object value : valueCollection) {
            MapInterfaceTest.assertTrue((boolean)map.containsValue(value));
            MapInterfaceTest.assertTrue((this.allowsNullValues || value != null ? 1 : 0) != 0);
        }
        MapInterfaceTest.assertEquals((int)map.size(), (int)entrySet.size());
        MapInterfaceTest.assertEquals((entrySet.size() == 0 ? 1 : 0) != 0, (boolean)entrySet.isEmpty());
        MapInterfaceTest.assertEquals((!entrySet.isEmpty() ? 1 : 0) != 0, (boolean)entrySet.iterator().hasNext());
        MapInterfaceTest.assertFalse((boolean)entrySet.contains("foo"));
        boolean supportsValuesHashCode = this.supportsValuesHashCode(map);
        if (supportsValuesHashCode) {
            int expectedEntrySetHash = 0;
            for (Map.Entry entry : entrySet) {
                MapInterfaceTest.assertTrue((boolean)map.containsKey(entry.getKey()));
                MapInterfaceTest.assertTrue((boolean)map.containsValue(entry.getValue()));
                int expectedHash = (entry.getKey() == null ? 0 : entry.getKey().hashCode()) ^ (entry.getValue() == null ? 0 : entry.getValue().hashCode());
                MapInterfaceTest.assertEquals((int)expectedHash, (int)entry.hashCode());
                expectedEntrySetHash += expectedHash;
            }
            MapInterfaceTest.assertEquals((int)expectedEntrySetHash, (int)entrySet.hashCode());
            MapInterfaceTest.assertTrue((boolean)entrySet.containsAll(new HashSet<Map.Entry<K, V>>(entrySet)));
            MapInterfaceTest.assertTrue((boolean)entrySet.equals(new HashSet<Map.Entry<K, V>>(entrySet)));
        }
        Object[] entrySetToArray1 = entrySet.toArray();
        MapInterfaceTest.assertEquals((int)map.size(), (int)entrySetToArray1.length);
        MapInterfaceTest.assertTrue((boolean)Arrays.asList(entrySetToArray1).containsAll(entrySet));
        Map.Entry[] entrySetToArray2 = new Map.Entry[map.size() + 2];
        entrySetToArray2[map.size()] = MapInterfaceTest.mapEntry("foo", 1);
        MapInterfaceTest.assertSame((Object)entrySetToArray2, (Object)entrySet.toArray(entrySetToArray2));
        MapInterfaceTest.assertNull((Object)entrySetToArray2[map.size()]);
        MapInterfaceTest.assertTrue((boolean)Arrays.asList(entrySetToArray2).containsAll(entrySet));
        Object[] objectArray = valueCollection.toArray();
        MapInterfaceTest.assertEquals((int)map.size(), (int)objectArray.length);
        MapInterfaceTest.assertTrue((boolean)Arrays.asList(objectArray).containsAll(valueCollection));
        Object[] valuesToArray2 = new Object[map.size() + 2];
        valuesToArray2[map.size()] = "foo";
        MapInterfaceTest.assertSame((Object)valuesToArray2, (Object)valueCollection.toArray(valuesToArray2));
        MapInterfaceTest.assertNull((Object)valuesToArray2[map.size()]);
        MapInterfaceTest.assertTrue((boolean)Arrays.asList(valuesToArray2).containsAll(valueCollection));
        if (supportsValuesHashCode) {
            int expectedHash = 0;
            for (Map.Entry<K, V> entry : entrySet) {
                expectedHash += entry.hashCode();
            }
            MapInterfaceTest.assertEquals((int)expectedHash, (int)map.hashCode());
        }
        this.assertMoreInvariants(map);
    }

    protected void assertMoreInvariants(Map<K, V> map) {
    }

    public void testClear() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsClear) {
            map.clear();
            MapInterfaceTest.assertTrue((boolean)map.isEmpty());
        } else {
            try {
                map.clear();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testContainsKey() {
        K unmappedKey;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
            unmappedKey = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertFalse((boolean)map.containsKey(unmappedKey));
        try {
            MapInterfaceTest.assertFalse((boolean)map.containsKey(new IncompatibleKeyType()));
        }
        catch (ClassCastException tolerated) {
            // empty catch block
        }
        MapInterfaceTest.assertTrue((boolean)map.containsKey(map.keySet().iterator().next()));
        if (this.allowsNullKeys) {
            map.containsKey(null);
        } else {
            try {
                map.containsKey(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testContainsValue() {
        V unmappedValue;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertFalse((boolean)map.containsValue(unmappedValue));
        MapInterfaceTest.assertTrue((boolean)map.containsValue(map.values().iterator().next()));
        if (this.allowsNullValues) {
            map.containsValue(null);
        } else {
            try {
                map.containsKey(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySet() {
        V unmappedValue;
        K unmappedKey;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        try {
            unmappedKey = this.getKeyNotInPopulatedMap();
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        for (Map.Entry<K, V> entry : entrySet) {
            MapInterfaceTest.assertFalse((boolean)unmappedKey.equals(entry.getKey()));
            MapInterfaceTest.assertFalse((boolean)unmappedValue.equals(entry.getValue()));
        }
    }

    public void testEntrySetForEmptyMap() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
    }

    public void testEntrySetContainsEntryIncompatibleKey() {
        V unmappedValue;
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Map.Entry<IncompatibleKeyType, V> entry = MapInterfaceTest.mapEntry(new IncompatibleKeyType(), unmappedValue);
        try {
            MapInterfaceTest.assertFalse((boolean)entrySet.contains(entry));
        }
        catch (ClassCastException tolerated) {
            // empty catch block
        }
    }

    public void testEntrySetContainsEntryNullKeyPresent() {
        V unmappedValue;
        Map<K, V> map;
        if (!this.allowsNullKeys || !this.supportsPut) {
            return;
        }
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        map.put(null, unmappedValue);
        Map.Entry<Object, V> entry = MapInterfaceTest.mapEntry(null, unmappedValue);
        MapInterfaceTest.assertTrue((boolean)entrySet.contains(entry));
        MapInterfaceTest.assertFalse((boolean)entrySet.contains(MapInterfaceTest.mapEntry(null, null)));
    }

    public void testEntrySetContainsEntryNullKeyMissing() {
        V unmappedValue;
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Map.Entry<Object, V> entry = MapInterfaceTest.mapEntry(null, unmappedValue);
        try {
            MapInterfaceTest.assertFalse((boolean)entrySet.contains(entry));
        }
        catch (NullPointerException e) {
            MapInterfaceTest.assertFalse((boolean)this.allowsNullKeys);
        }
        try {
            MapInterfaceTest.assertFalse((boolean)entrySet.contains(MapInterfaceTest.mapEntry(null, null)));
        }
        catch (NullPointerException e) {
            MapInterfaceTest.assertFalse((this.allowsNullKeys && this.allowsNullValues ? 1 : 0) != 0);
        }
    }

    public void testEntrySetIteratorRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Iterator<Map.Entry<K, V>> iterator = entrySet.iterator();
        if (this.supportsIteratorRemove) {
            int initialSize = map.size();
            Map.Entry<K, V> entry = iterator.next();
            Map.Entry<K, V> entryCopy = Helpers.mapEntry(entry.getKey(), entry.getValue());
            iterator.remove();
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
            MapInterfaceTest.assertFalse((boolean)entrySet.contains(entryCopy));
            this.assertInvariants(map);
            try {
                iterator.remove();
                MapInterfaceTest.fail((String)"Expected IllegalStateException.");
            }
            catch (IllegalStateException e) {}
        } else {
            try {
                iterator.next();
                iterator.remove();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        if (this.supportsRemove) {
            int initialSize = map.size();
            boolean didRemove = entrySet.remove(entrySet.iterator().next());
            MapInterfaceTest.assertTrue((boolean)didRemove);
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
        } else {
            try {
                entrySet.remove(entrySet.iterator().next());
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetRemoveMissingKey() {
        K key;
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
            key = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<K, V> entry = MapInterfaceTest.mapEntry(key, this.getValueNotInPopulatedMap());
        int initialSize = map.size();
        if (this.supportsRemove) {
            boolean didRemove = entrySet.remove(entry);
            MapInterfaceTest.assertFalse((boolean)didRemove);
        } else {
            try {
                boolean didRemove = entrySet.remove(entry);
                MapInterfaceTest.assertFalse((boolean)didRemove);
            }
            catch (UnsupportedOperationException optional) {
                // empty catch block
            }
        }
        MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        MapInterfaceTest.assertFalse((boolean)map.containsKey(key));
        this.assertInvariants(map);
    }

    public void testEntrySetRemoveDifferentValue() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        K key = map.keySet().iterator().next();
        Map.Entry<K, V> entry = MapInterfaceTest.mapEntry(key, this.getValueNotInPopulatedMap());
        int initialSize = map.size();
        if (this.supportsRemove) {
            boolean didRemove = entrySet.remove(entry);
            MapInterfaceTest.assertFalse((boolean)didRemove);
        } else {
            try {
                boolean didRemove = entrySet.remove(entry);
                MapInterfaceTest.assertFalse((boolean)didRemove);
            }
            catch (UnsupportedOperationException optional) {
                // empty catch block
            }
        }
        MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        MapInterfaceTest.assertTrue((boolean)map.containsKey(key));
        this.assertInvariants(map);
    }

    public void testEntrySetRemoveNullKeyPresent() {
        V unmappedValue;
        Map<K, V> map;
        if (!(this.allowsNullKeys && this.supportsPut && this.supportsRemove)) {
            return;
        }
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        map.put(null, unmappedValue);
        MapInterfaceTest.assertEquals(unmappedValue, map.get(null));
        MapInterfaceTest.assertTrue((boolean)map.containsKey(null));
        Map.Entry<Object, V> entry = MapInterfaceTest.mapEntry(null, unmappedValue);
        MapInterfaceTest.assertTrue((boolean)entrySet.remove(entry));
        MapInterfaceTest.assertNull(map.get(null));
        MapInterfaceTest.assertFalse((boolean)map.containsKey(null));
    }

    public void testEntrySetRemoveNullKeyMissing() {
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<Object, V> entry = MapInterfaceTest.mapEntry(null, this.getValueNotInPopulatedMap());
        int initialSize = map.size();
        if (this.supportsRemove) {
            try {
                boolean didRemove = entrySet.remove(entry);
                MapInterfaceTest.assertFalse((boolean)didRemove);
            }
            catch (NullPointerException e) {
                MapInterfaceTest.assertFalse((boolean)this.allowsNullKeys);
            }
        } else {
            try {
                boolean didRemove = entrySet.remove(entry);
                MapInterfaceTest.assertFalse((boolean)didRemove);
            }
            catch (UnsupportedOperationException optional) {
                // empty catch block
            }
        }
        MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        this.assertInvariants(map);
    }

    public void testEntrySetRemoveAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<K, V> entryToRemove = entrySet.iterator().next();
        Set<Map.Entry<K, V>> entriesToRemove = Collections.singleton(entryToRemove);
        if (this.supportsRemove) {
            Map.Entry<K, V> entryToRemoveCopy = Helpers.mapEntry(entryToRemove.getKey(), entryToRemove.getValue());
            int initialSize = map.size();
            boolean didRemove = entrySet.removeAll(entriesToRemove);
            MapInterfaceTest.assertTrue((boolean)didRemove);
            MapInterfaceTest.assertEquals((int)(initialSize - entriesToRemove.size()), (int)map.size());
            MapInterfaceTest.assertFalse((boolean)entrySet.contains(entryToRemoveCopy));
        } else {
            try {
                entrySet.removeAll(entriesToRemove);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetRemoveAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        if (this.supportsRemove) {
            try {
                entrySet.removeAll(null);
                MapInterfaceTest.fail((String)"Expected NullPointerException.");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                entrySet.removeAll(null);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException or NullPointerException.");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetRetainAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Set<Map.Entry<K, V>> entriesToRetain = Collections.singleton(entrySet.iterator().next());
        if (this.supportsRemove) {
            boolean shouldRemove = entrySet.size() > entriesToRetain.size();
            boolean didRemove = entrySet.retainAll(entriesToRetain);
            MapInterfaceTest.assertEquals((boolean)shouldRemove, (boolean)didRemove);
            MapInterfaceTest.assertEquals((int)entriesToRetain.size(), (int)map.size());
            for (Map.Entry<K, V> entry : entriesToRetain) {
                MapInterfaceTest.assertTrue((boolean)entrySet.contains(entry));
            }
        } else {
            try {
                entrySet.retainAll(entriesToRetain);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetRetainAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        if (this.supportsRemove) {
            try {
                entrySet.retainAll(null);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                entrySet.retainAll(null);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetClear() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        if (this.supportsClear) {
            entrySet.clear();
            MapInterfaceTest.assertTrue((boolean)entrySet.isEmpty());
        } else {
            try {
                entrySet.clear();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testEntrySetAddAndAddAll() {
        Map<K, V> map = this.makeEitherMap();
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<Object, Object> entryToAdd = MapInterfaceTest.mapEntry(null, null);
        try {
            entrySet.add(entryToAdd);
            MapInterfaceTest.fail((String)"Expected UnsupportedOperationException or NullPointerException.");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.assertInvariants(map);
        try {
            entrySet.addAll(Collections.singleton(entryToAdd));
            MapInterfaceTest.fail((String)"Expected UnsupportedOperationException or NullPointerException.");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.assertInvariants(map);
    }

    public void testEntrySetSetValue() {
        V valueToSet;
        Map<K, V> map;
        if (!this.supportsPut) {
            return;
        }
        try {
            map = this.makePopulatedMap();
            valueToSet = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        V oldValue = entry.getValue();
        V returnedValue = entry.setValue(valueToSet);
        MapInterfaceTest.assertEquals(oldValue, returnedValue);
        MapInterfaceTest.assertTrue((boolean)entrySet.contains(MapInterfaceTest.mapEntry(entry.getKey(), valueToSet)));
        MapInterfaceTest.assertEquals(valueToSet, map.get(entry.getKey()));
        this.assertInvariants(map);
    }

    public void testEntrySetSetValueSameValue() {
        Map<K, V> map;
        if (!this.supportsPut) {
            return;
        }
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        V oldValue = entry.getValue();
        V returnedValue = entry.setValue(oldValue);
        MapInterfaceTest.assertEquals(oldValue, returnedValue);
        MapInterfaceTest.assertTrue((boolean)entrySet.contains(MapInterfaceTest.mapEntry(entry.getKey(), oldValue)));
        MapInterfaceTest.assertEquals(oldValue, map.get(entry.getKey()));
        this.assertInvariants(map);
    }

    public void testEqualsForEqualMap() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertEquals(map, map);
        MapInterfaceTest.assertEquals(this.makePopulatedMap(), map);
        MapInterfaceTest.assertFalse((boolean)map.equals(Collections.emptyMap()));
        MapInterfaceTest.assertFalse((boolean)map.equals(null));
    }

    public void testEqualsForLargerMap() {
        Map<K, V> largerMap;
        Map<K, V> map;
        if (!this.supportsPut) {
            return;
        }
        try {
            map = this.makePopulatedMap();
            largerMap = this.makePopulatedMap();
            largerMap.put(this.getKeyNotInPopulatedMap(), this.getValueNotInPopulatedMap());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertFalse((boolean)map.equals(largerMap));
    }

    public void testEqualsForSmallerMap() {
        Map<K, V> smallerMap;
        Map<K, V> map;
        if (!this.supportsRemove) {
            return;
        }
        try {
            map = this.makePopulatedMap();
            smallerMap = this.makePopulatedMap();
            smallerMap.remove(smallerMap.keySet().iterator().next());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertFalse((boolean)map.equals(smallerMap));
    }

    public void testEqualsForEmptyMap() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertEquals(map, map);
        MapInterfaceTest.assertEquals(this.makeEmptyMap(), map);
        MapInterfaceTest.assertEquals(Collections.emptyMap(), map);
        MapInterfaceTest.assertFalse((boolean)map.equals(Collections.emptySet()));
        MapInterfaceTest.assertFalse((boolean)map.equals(null));
    }

    public void testGet() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            MapInterfaceTest.assertEquals(entry.getValue(), map.get(entry.getKey()));
        }
        Object unmappedKey = null;
        try {
            unmappedKey = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertNull(map.get(unmappedKey));
    }

    public void testGetForEmptyMap() {
        Map<K, V> map;
        Object unmappedKey = null;
        try {
            map = this.makeEmptyMap();
            unmappedKey = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        MapInterfaceTest.assertNull(map.get(unmappedKey));
    }

    public void testGetNull() {
        Map<K, V> map = this.makeEitherMap();
        if (this.allowsNullKeys) {
            if (!this.allowsNullValues) {
                MapInterfaceTest.assertEquals((boolean)map.containsKey(null), (map.get(null) != null ? 1 : 0) != 0);
            }
        } else {
            try {
                map.get(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testHashCode() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
    }

    public void testHashCodeForEmptyMap() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
    }

    public void testPutNewKey() {
        V valueToPut;
        K keyToPut;
        Map<K, V> map = this.makeEitherMap();
        try {
            keyToPut = this.getKeyNotInPopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsPut) {
            int initialSize = map.size();
            V oldValue = map.put(keyToPut, valueToPut);
            MapInterfaceTest.assertEquals(valueToPut, map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(valueToPut));
            MapInterfaceTest.assertEquals((int)(initialSize + 1), (int)map.size());
            MapInterfaceTest.assertNull(oldValue);
        } else {
            try {
                map.put(keyToPut, valueToPut);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutExistingKey() {
        V valueToPut;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        K keyToPut = map.keySet().iterator().next();
        if (this.supportsPut) {
            int initialSize = map.size();
            map.put(keyToPut, valueToPut);
            MapInterfaceTest.assertEquals(valueToPut, map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(valueToPut));
            MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        } else {
            try {
                map.put(keyToPut, valueToPut);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutNullKey() {
        V valueToPut;
        if (!this.supportsPut) {
            return;
        }
        Map<K, V> map = this.makeEitherMap();
        try {
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.allowsNullKeys) {
            V oldValue = map.get(null);
            V returnedValue = map.put(null, valueToPut);
            MapInterfaceTest.assertEquals(oldValue, returnedValue);
            MapInterfaceTest.assertEquals(valueToPut, map.get(null));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(null));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(valueToPut));
        } else {
            try {
                map.put(null, valueToPut);
                MapInterfaceTest.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutNullValue() {
        K keyToPut;
        if (!this.supportsPut) {
            return;
        }
        Map<K, V> map = this.makeEitherMap();
        try {
            keyToPut = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.allowsNullValues) {
            int initialSize = map.size();
            V oldValue = map.get(keyToPut);
            Object returnedValue = map.put(keyToPut, null);
            MapInterfaceTest.assertEquals(oldValue, returnedValue);
            MapInterfaceTest.assertNull(map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(null));
            MapInterfaceTest.assertEquals((int)(initialSize + 1), (int)map.size());
        } else {
            try {
                map.put(keyToPut, null);
                MapInterfaceTest.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutNullValueForExistingKey() {
        K keyToPut;
        Map<K, V> map;
        if (!this.supportsPut) {
            return;
        }
        try {
            map = this.makePopulatedMap();
            keyToPut = map.keySet().iterator().next();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.allowsNullValues) {
            int initialSize = map.size();
            V oldValue = map.get(keyToPut);
            Object returnedValue = map.put(keyToPut, null);
            MapInterfaceTest.assertEquals(oldValue, returnedValue);
            MapInterfaceTest.assertNull(map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(null));
            MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        } else {
            try {
                map.put(keyToPut, null);
                MapInterfaceTest.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutAllNewKey() {
        V valueToPut;
        K keyToPut;
        Map<K, V> map = this.makeEitherMap();
        try {
            keyToPut = this.getKeyNotInPopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Map<K, V> mapToPut = Collections.singletonMap(keyToPut, valueToPut);
        if (this.supportsPut) {
            int initialSize = map.size();
            map.putAll(mapToPut);
            MapInterfaceTest.assertEquals(valueToPut, map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(valueToPut));
            MapInterfaceTest.assertEquals((int)(initialSize + 1), (int)map.size());
        } else {
            try {
                map.putAll(mapToPut);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testPutAllExistingKey() {
        V valueToPut;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
            valueToPut = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        K keyToPut = map.keySet().iterator().next();
        Map<K, V> mapToPut = Collections.singletonMap(keyToPut, valueToPut);
        int initialSize = map.size();
        if (this.supportsPut) {
            map.putAll(mapToPut);
            MapInterfaceTest.assertEquals(valueToPut, map.get(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsKey(keyToPut));
            MapInterfaceTest.assertTrue((boolean)map.containsValue(valueToPut));
        } else {
            try {
                map.putAll(mapToPut);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        this.assertInvariants(map);
    }

    public void testRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        K keyToRemove = map.keySet().iterator().next();
        if (this.supportsRemove) {
            int initialSize = map.size();
            V expectedValue = map.get(keyToRemove);
            V oldValue = map.remove(keyToRemove);
            MapInterfaceTest.assertEquals(expectedValue, oldValue);
            MapInterfaceTest.assertFalse((boolean)map.containsKey(keyToRemove));
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
        } else {
            try {
                map.remove(keyToRemove);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testRemoveMissingKey() {
        K keyToRemove;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
            keyToRemove = this.getKeyNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.supportsRemove) {
            int initialSize = map.size();
            MapInterfaceTest.assertNull(map.remove(keyToRemove));
            MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        } else {
            try {
                map.remove(keyToRemove);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testSize() {
        this.assertInvariants(this.makeEitherMap());
    }

    public void testKeySetRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keys = map.keySet();
        K key = keys.iterator().next();
        if (this.supportsRemove) {
            int initialSize = map.size();
            keys.remove(key);
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
            MapInterfaceTest.assertFalse((boolean)map.containsKey(key));
        } else {
            try {
                keys.remove(key);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testKeySetRemoveAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keys = map.keySet();
        K key = keys.iterator().next();
        if (this.supportsRemove) {
            int initialSize = map.size();
            MapInterfaceTest.assertTrue((boolean)keys.removeAll(Collections.singleton(key)));
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
            MapInterfaceTest.assertFalse((boolean)map.containsKey(key));
        } else {
            try {
                keys.removeAll(Collections.singleton(key));
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testKeySetRetainAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keys = map.keySet();
        K key = keys.iterator().next();
        if (this.supportsRemove) {
            keys.retainAll(Collections.singleton(key));
            MapInterfaceTest.assertEquals((int)1, (int)map.size());
            MapInterfaceTest.assertTrue((boolean)map.containsKey(key));
        } else {
            try {
                keys.retainAll(Collections.singleton(key));
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testKeySetClear() {
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keySet = map.keySet();
        if (this.supportsClear) {
            keySet.clear();
            MapInterfaceTest.assertTrue((boolean)keySet.isEmpty());
        } else {
            try {
                keySet.clear();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testKeySetRemoveAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keySet = map.keySet();
        if (this.supportsRemove) {
            try {
                keySet.removeAll(null);
                MapInterfaceTest.fail((String)"Expected NullPointerException.");
            }
            catch (NullPointerException e) {}
        } else {
            try {
                keySet.removeAll(null);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException or NullPointerException.");
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testKeySetRetainAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Set<K> keySet = map.keySet();
        if (this.supportsRemove) {
            try {
                keySet.retainAll(null);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                keySet.retainAll(null);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValues() {
        V unmappedValue;
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.assertInvariants(map);
        Collection<V> valueCollection = map.values();
        try {
            unmappedValue = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        for (V value : valueCollection) {
            MapInterfaceTest.assertFalse((boolean)unmappedValue.equals(value));
        }
    }

    public void testValuesIteratorRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        Iterator<V> iterator = valueCollection.iterator();
        if (this.supportsIteratorRemove) {
            int initialSize = map.size();
            iterator.next();
            iterator.remove();
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
            this.assertInvariants(map);
            try {
                iterator.remove();
                MapInterfaceTest.fail((String)"Expected IllegalStateException.");
            }
            catch (IllegalStateException e) {}
        } else {
            try {
                iterator.next();
                iterator.remove();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesRemove() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        if (this.supportsRemove) {
            int initialSize = map.size();
            valueCollection.remove(valueCollection.iterator().next());
            MapInterfaceTest.assertEquals((int)(initialSize - 1), (int)map.size());
        } else {
            try {
                valueCollection.remove(valueCollection.iterator().next());
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesRemoveMissing() {
        V valueToRemove;
        Map<K, V> map;
        try {
            map = this.makeEitherMap();
            valueToRemove = this.getValueNotInPopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        int initialSize = map.size();
        if (this.supportsRemove) {
            MapInterfaceTest.assertFalse((boolean)valueCollection.remove(valueToRemove));
        } else {
            try {
                MapInterfaceTest.assertFalse((boolean)valueCollection.remove(valueToRemove));
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        MapInterfaceTest.assertEquals((int)initialSize, (int)map.size());
        this.assertInvariants(map);
    }

    public void testValuesRemoveAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        Set<V> valuesToRemove = Collections.singleton(valueCollection.iterator().next());
        if (this.supportsRemove) {
            valueCollection.removeAll(valuesToRemove);
            for (V value : valuesToRemove) {
                MapInterfaceTest.assertFalse((boolean)valueCollection.contains(value));
            }
            for (V value : valueCollection) {
                MapInterfaceTest.assertFalse((boolean)valuesToRemove.contains(value));
            }
        } else {
            try {
                valueCollection.removeAll(valuesToRemove);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesRemoveAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> values = map.values();
        if (this.supportsRemove) {
            try {
                values.removeAll(null);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                values.removeAll(null);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesRetainAll() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        Set<V> valuesToRetain = Collections.singleton(valueCollection.iterator().next());
        if (this.supportsRemove) {
            valueCollection.retainAll(valuesToRetain);
            for (V value : valuesToRetain) {
                MapInterfaceTest.assertTrue((boolean)valueCollection.contains(value));
            }
            for (V value : valueCollection) {
                MapInterfaceTest.assertTrue((boolean)valuesToRetain.contains(value));
            }
        } else {
            try {
                valueCollection.retainAll(valuesToRetain);
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesRetainAllNullFromEmpty() {
        Map<K, V> map;
        try {
            map = this.makeEmptyMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> values = map.values();
        if (this.supportsRemove) {
            try {
                values.retainAll(null);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                values.retainAll(null);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    public void testValuesClear() {
        Map<K, V> map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Collection<V> valueCollection = map.values();
        if (this.supportsClear) {
            valueCollection.clear();
            MapInterfaceTest.assertTrue((boolean)valueCollection.isEmpty());
        } else {
            try {
                valueCollection.clear();
                MapInterfaceTest.fail((String)"Expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.assertInvariants(map);
    }

    static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    private static final class IncompatibleKeyType {
        private IncompatibleKeyType() {
        }

        public String toString() {
            return "IncompatibleKeyType";
        }
    }
}

