/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.DerivedCollectionGenerators;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SortedMapTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.testers.NavigableMapNavigationTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import junit.framework.TestSuite;

public class NavigableMapTestSuiteBuilder<K, V>
extends SortedMapTestSuiteBuilder<K, V> {
    public static <K, V> NavigableMapTestSuiteBuilder<K, V> using(TestSortedMapGenerator<K, V> generator) {
        NavigableMapTestSuiteBuilder<K, V> result = new NavigableMapTestSuiteBuilder<K, V>();
        result.usingGenerator(generator);
        return result;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(NavigableMapNavigationTester.class);
        return testers;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (!parentBuilder.getFeatures().contains(SortedMapTestSuiteBuilder.NoRecurse.DESCENDING)) {
            derivedSuites.add(this.createDescendingSuite(parentBuilder));
        }
        if (!parentBuilder.getFeatures().contains(SortedMapTestSuiteBuilder.NoRecurse.SUBMAP)) {
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.NO_BOUND, DerivedCollectionGenerators.Bound.INCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.NO_BOUND));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.INCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.INCLUSIVE));
        }
        return derivedSuites;
    }

    @Override
    protected NavigableSetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return NavigableSetTestSuiteBuilder.using((TestSortedSetGenerator)keySetGenerator);
    }

    @Override
    public NavigableMapTestSuiteBuilder<K, V> newBuilderUsing(TestSortedMapGenerator<K, V> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
        return this.subSuiteUsing(new NavigableMapSubmapTestMapGenerator<K, V>(delegate, to, from));
    }

    private TestSuite createDescendingSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        TestSortedMapGenerator delegate = (TestSortedMapGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(SortedMapTestSuiteBuilder.NoRecurse.DESCENDING);
        features.addAll(parentBuilder.getFeatures());
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)this.subSuiteUsing(new DescendingTestMapGenerator(delegate)).named(String.valueOf(parentBuilder.getName()).concat(" descending"))).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    NavigableMapTestSuiteBuilder<K, V> subSuiteUsing(TestSortedMapGenerator<K, V> generator) {
        return NavigableMapTestSuiteBuilder.using(generator);
    }

    static class DescendingTestMapGenerator<K, V>
    extends DerivedCollectionGenerators.ForwardingTestMapGenerator<K, V>
    implements TestSortedMapGenerator<K, V> {
        DescendingTestMapGenerator(TestSortedMapGenerator<K, V> delegate) {
            super(delegate);
        }

        @Override
        public NavigableMap<K, V> create(Object ... entries) {
            NavigableMap map = (NavigableMap)this.delegate.create(entries);
            return map.descendingMap();
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            insertionOrder = Helpers.castOrCopyToList(this.delegate.order(insertionOrder));
            Collections.reverse(insertionOrder);
            return insertionOrder;
        }

        TestSortedMapGenerator<K, V> delegate() {
            return (TestSortedMapGenerator)this.delegate;
        }

        @Override
        public Map.Entry<K, V> belowSamplesLesser() {
            return this.delegate().aboveSamplesGreater();
        }

        @Override
        public Map.Entry<K, V> belowSamplesGreater() {
            return this.delegate().aboveSamplesLesser();
        }

        @Override
        public Map.Entry<K, V> aboveSamplesLesser() {
            return this.delegate().belowSamplesGreater();
        }

        @Override
        public Map.Entry<K, V> aboveSamplesGreater() {
            return this.delegate().belowSamplesLesser();
        }
    }

    public static final class NavigableMapSubmapTestMapGenerator<K, V>
    extends DerivedCollectionGenerators.SortedMapSubmapTestMapGenerator<K, V> {
        public NavigableMapSubmapTestMapGenerator(TestSortedMapGenerator<K, V> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
            super(delegate, to, from);
        }

        @Override
        NavigableMap<K, V> createSubMap(SortedMap<K, V> sortedMap, K firstExclusive, K lastExclusive) {
            NavigableMap map = (NavigableMap)sortedMap;
            if (this.from == DerivedCollectionGenerators.Bound.NO_BOUND && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return map.headMap(this.lastInclusive, true);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.NO_BOUND) {
                return map.tailMap(firstExclusive, false);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.EXCLUSIVE) {
                return map.subMap(firstExclusive, false, lastExclusive, false);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return map.subMap(firstExclusive, false, this.lastInclusive, true);
            }
            if (this.from == DerivedCollectionGenerators.Bound.INCLUSIVE && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return map.subMap(this.firstInclusive, true, this.lastInclusive, true);
            }
            return (NavigableMap)super.createSubMap(map, firstExclusive, lastExclusive);
        }
    }
}

