/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.testers.Platform;
import java.util.Collection;
import java.util.List;

@GwtCompatible
public class AbstractListTester<E>
extends AbstractCollectionTester<E> {
    protected final List<E> getList() {
        return (List)this.collection;
    }

    @Override
    protected void expectContents(Collection<E> expectedCollection) {
        List<E> expectedList = Helpers.copyToList(expectedCollection);
        if (this.getList().size() != expectedList.size()) {
            String string = String.valueOf(this.reportContext(expectedList));
            AbstractListTester.fail((String)(string.length() != 0 ? "size mismatch: ".concat(string) : new String("size mismatch: ")));
        }
        for (int i = 0; i < expectedList.size(); ++i) {
            E actual;
            E expected = expectedList.get(i);
            if (expected == (actual = this.getList().get(i)) || expected != null && expected.equals(actual)) continue;
            int n = i;
            String string = this.reportContext(expectedList);
            AbstractListTester.fail((String)new StringBuilder(31 + String.valueOf(string).length()).append("mismatch at index ").append(n).append(": ").append(string).toString());
        }
    }

    private String reportContext(List<E> expected) {
        return Platform.format("expected collection %s; actual collection %s", expected, this.collection);
    }
}

