/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.testing.RelationshipTester;
import java.util.List;
import junit.framework.Assert;

@Beta
@GwtCompatible
public final class EqualsTester {
    private static final int REPETITIONS = 3;
    private final List<List<Object>> equalityGroups = Lists.newArrayList();
    private final RelationshipTester.ItemReporter itemReporter;

    public EqualsTester() {
        this(new RelationshipTester.ItemReporter());
    }

    EqualsTester(RelationshipTester.ItemReporter itemReporter) {
        this.itemReporter = (RelationshipTester.ItemReporter)Preconditions.checkNotNull((Object)itemReporter);
    }

    public EqualsTester addEqualityGroup(Object ... equalityGroup) {
        Preconditions.checkNotNull((Object)equalityGroup);
        this.equalityGroups.add((List<Object>)ImmutableList.copyOf((Object[])equalityGroup));
        return this;
    }

    public EqualsTester testEquals() {
        RelationshipTester<Object> delegate = new RelationshipTester<Object>(Equivalence.equals(), "Object#equals", "Object#hashCode", this.itemReporter);
        for (List<Object> group : this.equalityGroups) {
            delegate.addRelatedGroup(group);
        }
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (Object item : Iterables.concat(this.equalityGroups)) {
            String string = String.valueOf(item);
            Assert.assertTrue((String)new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" must not be Object#equals to null").toString(), (!item.equals(null) ? 1 : 0) != 0);
            string = String.valueOf(item);
            Assert.assertTrue((String)new StringBuilder(66 + String.valueOf(string).length()).append(string).append(" must not be Object#equals to an arbitrary object of another class").toString(), (!item.equals((Object)NotAnInstance.EQUAL_TO_NOTHING) ? 1 : 0) != 0);
            string = String.valueOf(item);
            Assert.assertEquals((String)new StringBuilder(32 + String.valueOf(string).length()).append(string).append(" must be Object#equals to itself").toString(), item, item);
            string = String.valueOf(item);
            Assert.assertEquals((String)new StringBuilder(42 + String.valueOf(string).length()).append("the Object#hashCode of ").append(string).append(" must be consistent").toString(), (int)item.hashCode(), (int)item.hashCode());
        }
    }

    private static enum NotAnInstance {
        EQUAL_TO_NOTHING;

    }
}

