/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@GwtCompatible(emulated=true)
public class MapCreationTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeySupported() {
        this.initMapWithNullKey();
        this.expectContents(this.createArrayWithNullKey());
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeyUnsupported() {
        try {
            this.initMapWithNullKey();
            MapCreationTester.fail((String)"Creating a map containing a null key should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullValueSupported() {
        this.initMapWithNullValue();
        this.expectContents(this.createArrayWithNullValue());
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullValueUnsupported() {
        try {
            this.initMapWithNullValue();
            MapCreationTester.fail((String)"Creating a map containing a null value should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNullKeyAndValueSupported() {
        Map.Entry[] entries = (Map.Entry[])this.createSamplesArray();
        entries[this.getNullLocation()] = this.entry(null, null);
        this.resetMap(entries);
        this.expectContents(entries);
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS}, absent={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesNotRejected() {
        this.expectFirstRemoved(this.getEntriesMultipleNullKeys());
    }

    @MapFeature.Require(absent={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesNotRejected() {
        this.expectFirstRemoved(this.getEntriesMultipleNonNullKeys());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nullDuplicatesRejected() {
        Map.Entry<K, V>[] entries = this.getEntriesMultipleNullKeys();
        try {
            this.resetMap(entries);
            MapCreationTester.fail((String)"Should reject duplicate null elements at creation");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.REJECTS_DUPLICATES_AT_CREATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testCreateWithDuplicates_nonNullDuplicatesRejected() {
        Map.Entry<K, V>[] entries = this.getEntriesMultipleNonNullKeys();
        try {
            this.resetMap(entries);
            MapCreationTester.fail((String)"Should reject duplicate non-null elements at creation");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Map.Entry<K, V>[] getEntriesMultipleNullKeys() {
        Map.Entry<K, V>[] entries = this.createArrayWithNullKey();
        entries[0] = this.entry(null, entries[0].getValue());
        return entries;
    }

    private Map.Entry<K, V>[] getEntriesMultipleNonNullKeys() {
        Map.Entry[] entries = (Map.Entry[])this.createSamplesArray();
        entries[0] = this.entry(this.k1(), this.v0());
        return entries;
    }

    private void expectFirstRemoved(Map.Entry<K, V>[] entries) {
        this.resetMap(entries);
        List<Map.Entry<K, V>> expectedWithDuplicateRemoved = Arrays.asList(entries).subList(1, this.getNumElements());
        this.expectContents(expectedWithDuplicateRemoved);
    }

    @GwtIncompatible(value="reflection")
    public static Method getCreateWithNullKeyUnsupportedMethod() {
        return Helpers.getMethod(MapCreationTester.class, "testCreateWithNullKeyUnsupported");
    }
}

