/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph.testing;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;

public final class TestGraphBuilder<N> {
    private final MutableGraph<N> graph;

    private TestGraphBuilder(MutableGraph<N> graph) {
        this.graph = graph;
    }

    public static <N> TestGraphBuilder<N> init(GraphBuilder<? super N> builder) {
        return new TestGraphBuilder<N>(builder.build());
    }

    public TestGraphBuilder<N> addNode(N node) {
        this.graph.addNode(node);
        return this;
    }

    public TestGraphBuilder<N> addEdge(N node1, N node2) {
        this.graph.addEdge(node1, node2);
        return this;
    }

    public ImmutableGraph<N> toImmutableGraph() {
        return ImmutableGraph.copyOf(this.graph);
    }
}

