/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MinimalCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public class MinimalSet<E>
extends MinimalCollection<E>
implements Set<E> {
    public static <E> MinimalSet<E> of(E ... contents) {
        return MinimalSet.ofClassAndContents(Object.class, new Object[0], Arrays.asList(contents));
    }

    public static <E> MinimalSet<E> from(Collection<? extends E> contents) {
        return MinimalSet.ofClassAndContents(Object.class, new Object[0], contents);
    }

    public static <E> MinimalSet<E> ofClassAndContents(Class<? super E> type, E[] emptyArrayForContents, Iterable<? extends E> contents) {
        ArrayList<E> setContents = new ArrayList<E>();
        for (E e : contents) {
            if (setContents.contains(e)) continue;
            setContents.add(e);
        }
        return new MinimalSet<E>(type, setContents.toArray(emptyArrayForContents));
    }

    private MinimalSet(Class<? super E> type, E ... contents) {
        super(type, true, contents);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Set) {
            Set that = (Set)object;
            return this.size() == that.size() && this.containsAll(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCodeSum = 0;
        for (Object o : this) {
            hashCodeSum += o == null ? 0 : o.hashCode();
        }
        return hashCodeSum;
    }
}

