/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
@J2ktIncompatible
class FreshValueGenerator {
    private static final ImmutableMap<Class<?>, Method> GENERATORS;
    private static final ImmutableMap<Class<?>, Method> EMPTY_GENERATORS;
    private final AtomicInteger freshness = new AtomicInteger(1);
    private final ListMultimap<Class<?>, Object> sampleInstances = ArrayListMultimap.create();
    private final Map<Type, Integer> emptyInstanceGenerated = new HashMap<Type, Integer>();

    FreshValueGenerator() {
    }

    final <T> void addSampleInstances(Class<T> type, Iterable<? extends T> instances) {
        this.sampleInstances.putAll((Object)((Class)Preconditions.checkNotNull(type)), (Iterable)Preconditions.checkNotNull(instances));
    }

    final @Nullable Object generateFresh(TypeToken<?> type) {
        Object generated = this.generate(type);
        if (generated != null) {
            this.freshness.incrementAndGet();
        }
        return generated;
    }

    final <T> @Nullable T generateFresh(Class<T> type) {
        return Primitives.wrap(type).cast(this.generateFresh(TypeToken.of(type)));
    }

    final <T> T newFreshProxy(Class<T> interfaceType) {
        T proxy = this.newProxy(interfaceType);
        this.freshness.incrementAndGet();
        return proxy;
    }

    private @Nullable Object generate(TypeToken<?> type) {
        Method generate;
        Class rawType = type.getRawType();
        List samples = this.sampleInstances.get((Object)rawType);
        Object sample = this.pickInstance(samples, null);
        if (sample != null) {
            return sample;
        }
        if (rawType.isEnum()) {
            return this.pickInstance(rawType.getEnumConstants(), null);
        }
        if (type.isArray()) {
            TypeToken componentType = Objects.requireNonNull(type.getComponentType());
            Object array = Array.newInstance(componentType.getRawType(), 1);
            Array.set(array, 0, this.generate(componentType));
            return array;
        }
        Method emptyGenerate = (Method)EMPTY_GENERATORS.get((Object)rawType);
        if (emptyGenerate != null) {
            if (this.emptyInstanceGenerated.containsKey(type.getType())) {
                if (this.emptyInstanceGenerated.get(type.getType()).intValue() == this.freshness.get()) {
                    return this.invokeGeneratorMethod(emptyGenerate, new Object[0]);
                }
            } else {
                Object emptyInstance = this.invokeGeneratorMethod(emptyGenerate, new Object[0]);
                this.emptyInstanceGenerated.put(type.getType(), this.freshness.get());
                return emptyInstance;
            }
        }
        if ((generate = (Method)GENERATORS.get((Object)rawType)) != null) {
            ImmutableList params = Invokable.from((Method)generate).getParameters();
            ArrayList args = Lists.newArrayListWithCapacity((int)params.size());
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < params.size(); ++i) {
                TypeToken paramType = type.resolveType(typeVars[i]);
                Object argValue = this.generate(paramType);
                if (argValue == null) {
                    return null;
                }
                args.add(argValue);
            }
            return this.invokeGeneratorMethod(generate, args.toArray());
        }
        return this.defaultGenerate(rawType);
    }

    private <T> @Nullable T defaultGenerate(Class<T> rawType) {
        if (rawType.isInterface()) {
            return this.newProxy(rawType);
        }
        return ArbitraryInstances.get(rawType);
    }

    private <T> T newProxy(Class<T> interfaceType) {
        return (T)Reflection.newProxy(interfaceType, (InvocationHandler)((Object)new FreshInvocationHandler(interfaceType)));
    }

    private Object invokeGeneratorMethod(Method generator, Object ... args) {
        try {
            return generator.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    Object interfaceMethodCalled(Class<?> interfaceType, Method method) {
        throw new UnsupportedOperationException();
    }

    private <T> T pickInstance(T[] instances, T defaultValue) {
        return this.pickInstance(Arrays.asList(instances), defaultValue);
    }

    private <T> T pickInstance(Collection<T> instances, T defaultValue) {
        if (instances.isEmpty()) {
            return defaultValue;
        }
        return (T)Iterables.get(instances, (int)((this.generateInt() - 1) % instances.size()));
    }

    private static String paramString(Class<?> type, int i) {
        return type.getSimpleName() + '@' + i;
    }

    @Generates
    Class<?> generateClass() {
        return this.pickInstance((Collection)ImmutableList.of(Integer.TYPE, Long.TYPE, Void.TYPE, Object.class, Object[].class, Iterable.class), (Object)Object.class);
    }

    @Generates
    Object generateObject() {
        return this.generateString();
    }

    @Generates
    Number generateNumber() {
        return this.generateInt();
    }

    @Generates
    int generateInt() {
        return this.freshness.get();
    }

    @Generates
    Integer generateInteger() {
        return new Integer(this.generateInt());
    }

    @Generates
    long generateLong() {
        return this.generateInt();
    }

    @Generates
    Long generateLongObject() {
        return new Long(this.generateLong());
    }

    @Generates
    float generateFloat() {
        return this.generateInt();
    }

    @Generates
    Float generateFloatObject() {
        return new Float(this.generateFloat());
    }

    @Generates
    double generateDouble() {
        return this.generateInt();
    }

    @Generates
    Double generateDoubleObject() {
        return new Double(this.generateDouble());
    }

    @Generates
    short generateShort() {
        return (short)this.generateInt();
    }

    @Generates
    Short generateShortObject() {
        return new Short(this.generateShort());
    }

    @Generates
    byte generateByte() {
        return (byte)this.generateInt();
    }

    @Generates
    Byte generateByteObject() {
        return new Byte(this.generateByte());
    }

    @Generates
    char generateChar() {
        return this.generateString().charAt(0);
    }

    @Generates
    Character generateCharacter() {
        return new Character(this.generateChar());
    }

    @Generates
    boolean generateBoolean() {
        return this.generateInt() % 2 == 0;
    }

    @Generates
    Boolean generateBooleanObject() {
        return new Boolean(this.generateBoolean());
    }

    @Generates
    UnsignedInteger generateUnsignedInteger() {
        return UnsignedInteger.fromIntBits((int)this.generateInt());
    }

    @Generates
    UnsignedLong generateUnsignedLong() {
        return UnsignedLong.fromLongBits((long)this.generateLong());
    }

    @Generates
    BigInteger generateBigInteger() {
        return BigInteger.valueOf(this.generateInt());
    }

    @Generates
    BigDecimal generateBigDecimal() {
        return BigDecimal.valueOf(this.generateInt());
    }

    @Generates
    CharSequence generateCharSequence() {
        return this.generateString();
    }

    @Generates
    String generateString() {
        return Integer.toString(this.generateInt());
    }

    @Generates
    Comparable<?> generateComparable() {
        return this.generateString();
    }

    @Generates
    Pattern generatePattern() {
        return Pattern.compile(this.generateString());
    }

    @Generates
    Charset generateCharset() {
        return this.pickInstance(Charset.availableCharsets().values(), StandardCharsets.UTF_8);
    }

    @Generates
    Locale generateLocale() {
        return this.pickInstance(Locale.getAvailableLocales(), Locale.US);
    }

    @Generates
    Currency generateCurrency() {
        return this.pickInstance(Currency.getAvailableCurrencies(), Currency.getInstance(Locale.US));
    }

    @Empty
    <T> Optional<T> generateGoogleOptional() {
        return Optional.absent();
    }

    @Generates
    <T> Optional<T> generateGoogleOptional(T value) {
        return Optional.of(value);
    }

    @Generates
    Joiner generateJoiner() {
        return Joiner.on((String)this.generateString());
    }

    @Generates
    Splitter generateSplitter() {
        return Splitter.on((String)this.generateString());
    }

    @Generates
    <T> Equivalence<T> generateEquivalence() {
        return new Equivalence<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Equivalence.class, FreshValueGenerator.this.generateInt());
            }

            protected boolean doEquivalent(T a, T b) {
                return false;
            }

            protected int doHash(T t) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    CharMatcher generateCharMatcher() {
        return new CharMatcher(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(CharMatcher.class, FreshValueGenerator.this.generateInt());
            }

            public boolean matches(char c) {
                return false;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    Ticker generateTicker() {
        return new Ticker(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ticker.class, FreshValueGenerator.this.generateInt());
            }

            public long read() {
                return 0L;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    <T> Comparator<T> generateComparator() {
        return this.generateOrdering();
    }

    @Generates
    <T> Ordering<T> generateOrdering() {
        return new Ordering<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ordering.class, FreshValueGenerator.this.generateInt());
            }

            public int compare(T left, T right) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Empty
    static <C extends Comparable<?>> Range<C> generateRange() {
        return Range.all();
    }

    @Generates
    static <C extends Comparable<?>> Range<C> generateRange(C freshElement) {
        return Range.singleton(freshElement);
    }

    @Generates
    static <E> Iterable<E> generateIterable(@Nullable E freshElement) {
        return FreshValueGenerator.generateList(freshElement);
    }

    @Generates
    static <E> Collection<E> generateCollection(@Nullable E freshElement) {
        return FreshValueGenerator.generateList(freshElement);
    }

    @Generates
    static <E> List<E> generateList(@Nullable E freshElement) {
        return FreshValueGenerator.generateArrayList(freshElement);
    }

    @Generates
    static <E> ArrayList<E> generateArrayList(@Nullable E freshElement) {
        ArrayList list = Lists.newArrayList();
        list.add(freshElement);
        return list;
    }

    @Generates
    static <E> LinkedList<E> generateLinkedList(@Nullable E freshElement) {
        LinkedList list = Lists.newLinkedList();
        list.add(freshElement);
        return list;
    }

    @Generates
    static <E> ImmutableList<E> generateImmutableList(E freshElement) {
        return ImmutableList.of(freshElement);
    }

    @Generates
    static <E> ImmutableCollection<E> generateImmutableCollection(E freshElement) {
        return FreshValueGenerator.generateImmutableList(freshElement);
    }

    @Generates
    static <E> Set<E> generateSet(@Nullable E freshElement) {
        return FreshValueGenerator.generateHashSet(freshElement);
    }

    @Generates
    static <E> HashSet<E> generateHashSet(@Nullable E freshElement) {
        return FreshValueGenerator.generateLinkedHashSet(freshElement);
    }

    @Generates
    static <E> LinkedHashSet<E> generateLinkedHashSet(@Nullable E freshElement) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    static <E> ImmutableSet<E> generateImmutableSet(E freshElement) {
        return ImmutableSet.of(freshElement);
    }

    @Generates
    static <E extends Comparable<? super E>> SortedSet<E> generateSortedSet(E freshElement) {
        return FreshValueGenerator.generateNavigableSet(freshElement);
    }

    @Generates
    static <E extends Comparable<? super E>> NavigableSet<E> generateNavigableSet(E freshElement) {
        return FreshValueGenerator.generateTreeSet(freshElement);
    }

    @Generates
    static <E extends Comparable<? super E>> TreeSet<E> generateTreeSet(E freshElement) {
        TreeSet set = Sets.newTreeSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    static <E extends Comparable<? super E>> ImmutableSortedSet<E> generateImmutableSortedSet(E freshElement) {
        return ImmutableSortedSet.of(freshElement);
    }

    @Generates
    static <E> Multiset<E> generateMultiset(@Nullable E freshElement) {
        return FreshValueGenerator.generateHashMultiset(freshElement);
    }

    @Generates
    static <E> HashMultiset<E> generateHashMultiset(@Nullable E freshElement) {
        HashMultiset multiset = HashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    static <E> LinkedHashMultiset<E> generateLinkedHashMultiset(@Nullable E freshElement) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    static <E> ImmutableMultiset<E> generateImmutableMultiset(E freshElement) {
        return ImmutableMultiset.of(freshElement);
    }

    @Generates
    static <E extends Comparable<E>> SortedMultiset<E> generateSortedMultiset(E freshElement) {
        return FreshValueGenerator.generateTreeMultiset(freshElement);
    }

    @Generates
    static <E extends Comparable<E>> TreeMultiset<E> generateTreeMultiset(E freshElement) {
        TreeMultiset multiset = TreeMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    static <E extends Comparable<E>> ImmutableSortedMultiset<E> generateImmutableSortedMultiset(E freshElement) {
        return ImmutableSortedMultiset.of(freshElement);
    }

    @Generates
    static <K, V> Map<K, V> generateMap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateHashdMap(key, value);
    }

    @Generates
    static <K, V> HashMap<K, V> generateHashdMap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateLinkedHashMap(key, value);
    }

    @Generates
    static <K, V> LinkedHashMap<K, V> generateLinkedHashMap(@Nullable K key, @Nullable V value) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    @Generates
    static <K, V> ImmutableMap<K, V> generateImmutableMap(K key, V value) {
        return ImmutableMap.of(key, value);
    }

    @Empty
    static <K, V> ConcurrentMap<K, V> generateConcurrentMap() {
        return Maps.newConcurrentMap();
    }

    @Generates
    static <K, V> ConcurrentMap<K, V> generateConcurrentMap(K key, V value) {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put(key, value);
        return map;
    }

    @Generates
    static <K extends Comparable<? super K>, V> SortedMap<K, V> generateSortedMap(K key, @Nullable V value) {
        return FreshValueGenerator.generateNavigableMap(key, value);
    }

    @Generates
    static <K extends Comparable<? super K>, V> NavigableMap<K, V> generateNavigableMap(K key, @Nullable V value) {
        return FreshValueGenerator.generateTreeMap(key, value);
    }

    @Generates
    static <K extends Comparable<? super K>, V> TreeMap<K, V> generateTreeMap(K key, @Nullable V value) {
        TreeMap map = Maps.newTreeMap();
        map.put(key, value);
        return map;
    }

    @Generates
    static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> generateImmutableSortedMap(K key, V value) {
        return ImmutableSortedMap.of(key, value);
    }

    @Generates
    static <K, V> Multimap<K, V> generateMultimap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateListMultimap(key, value);
    }

    @Generates
    static <K, V> ImmutableMultimap<K, V> generateImmutableMultimap(K key, V value) {
        return ImmutableMultimap.of(key, value);
    }

    @Generates
    static <K, V> ListMultimap<K, V> generateListMultimap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateArrayListMultimap(key, value);
    }

    @Generates
    static <K, V> ArrayListMultimap<K, V> generateArrayListMultimap(@Nullable K key, @Nullable V value) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    static <K, V> ImmutableListMultimap<K, V> generateImmutableListMultimap(K key, V value) {
        return ImmutableListMultimap.of(key, value);
    }

    @Generates
    static <K, V> SetMultimap<K, V> generateSetMultimap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateLinkedHashMultimap(key, value);
    }

    @Generates
    static <K, V> HashMultimap<K, V> generateHashMultimap(@Nullable K key, @Nullable V value) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    static <K, V> LinkedHashMultimap<K, V> generateLinkedHashMultimap(@Nullable K key, @Nullable V value) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    static <K, V> ImmutableSetMultimap<K, V> generateImmutableSetMultimap(K key, V value) {
        return ImmutableSetMultimap.of(key, value);
    }

    @Generates
    static <K, V> BiMap<K, V> generateBimap(@Nullable K key, @Nullable V value) {
        return FreshValueGenerator.generateHashBiMap(key, value);
    }

    @Generates
    static <K, V> HashBiMap<K, V> generateHashBiMap(@Nullable K key, @Nullable V value) {
        HashBiMap bimap = HashBiMap.create();
        bimap.put(key, value);
        return bimap;
    }

    @Generates
    static <K, V> ImmutableBiMap<K, V> generateImmutableBimap(K key, V value) {
        return ImmutableBiMap.of(key, value);
    }

    @Generates
    static <R, C, V> Table<R, C, V> generateTable(R row, C column, V value) {
        return FreshValueGenerator.generateHashBasedTable(row, column, value);
    }

    @Generates
    static <R, C, V> HashBasedTable<R, C, V> generateHashBasedTable(R row, C column, V value) {
        HashBasedTable table = HashBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    static <R extends Comparable, C extends Comparable, V> RowSortedTable<R, C, V> generateRowSortedTable(R row, C column, V value) {
        return FreshValueGenerator.generateTreeBasedTable(row, column, value);
    }

    @Generates
    static <R extends Comparable, C extends Comparable, V> TreeBasedTable<R, C, V> generateTreeBasedTable(R row, C column, V value) {
        TreeBasedTable table = TreeBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    static <R, C, V> ImmutableTable<R, C, V> generateImmutableTable(R row, C column, V value) {
        return ImmutableTable.of(row, column, value);
    }

    @Generates
    TypeToken<?> generateTypeToken() {
        return TypeToken.of(this.generateClass());
    }

    @Generates
    File generateFile() {
        return new File(this.generateString());
    }

    @Generates
    static ByteArrayInputStream generateByteArrayInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Generates
    static InputStream generateInputStream() {
        return FreshValueGenerator.generateByteArrayInputStream();
    }

    @Generates
    StringReader generateStringReader() {
        return new StringReader(this.generateString());
    }

    @Generates
    Reader generateReader() {
        return this.generateStringReader();
    }

    @Generates
    Readable generateReadable() {
        return this.generateReader();
    }

    @Generates
    Buffer generateBuffer() {
        return this.generateCharBuffer();
    }

    @Generates
    CharBuffer generateCharBuffer() {
        return CharBuffer.allocate(this.generateInt());
    }

    @Generates
    ByteBuffer generateByteBuffer() {
        return ByteBuffer.allocate(this.generateInt());
    }

    @Generates
    ShortBuffer generateShortBuffer() {
        return ShortBuffer.allocate(this.generateInt());
    }

    @Generates
    IntBuffer generateIntBuffer() {
        return IntBuffer.allocate(this.generateInt());
    }

    @Generates
    LongBuffer generateLongBuffer() {
        return LongBuffer.allocate(this.generateInt());
    }

    @Generates
    FloatBuffer generateFloatBuffer() {
        return FloatBuffer.allocate(this.generateInt());
    }

    @Generates
    DoubleBuffer generateDoubleBuffer() {
        return DoubleBuffer.allocate(this.generateInt());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : FreshValueGenerator.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Generates.class)) continue;
            builder.put(method.getReturnType(), (Object)method);
        }
        GENERATORS = builder.buildOrThrow();
        builder = ImmutableMap.builder();
        for (Method method : FreshValueGenerator.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Empty.class)) continue;
            builder.put(method.getReturnType(), (Object)method);
        }
        EMPTY_GENERATORS = builder.buildOrThrow();
    }

    private final class FreshInvocationHandler
    extends AbstractInvocationHandler {
        private final int identity;
        private final Class<?> interfaceType;

        FreshInvocationHandler(Class<?> interfaceType) {
            this.identity = FreshValueGenerator.this.generateInt();
            this.interfaceType = interfaceType;
        }

        @CheckForNull
        protected Object handleInvocation(Object proxy, Method method, @Nullable Object[] args) {
            return FreshValueGenerator.this.interfaceMethodCalled(this.interfaceType, method);
        }

        public int hashCode() {
            return this.identity;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof FreshInvocationHandler) {
                FreshInvocationHandler that = (FreshInvocationHandler)((Object)obj);
                return this.identity == that.identity;
            }
            return false;
        }

        public String toString() {
            return FreshValueGenerator.paramString(this.interfaceType, this.identity);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Generates {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Empty {
    }
}

