/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class CollectionAddAllTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_supportedNothing() {
        CollectionAddAllTester.assertFalse((String)"addAll(nothing) should return false", (boolean)this.collection.addAll(this.emptyCollection()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_unsupportedNothing() {
        try {
            CollectionAddAllTester.assertFalse((String)"addAll(nothing) should return false or throw", (boolean)this.collection.addAll(this.emptyCollection()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_supportedNonePresent() {
        CollectionAddAllTester.assertTrue((String)"addAll(nonePresent) should return true", (boolean)this.collection.addAll(this.createDisjointCollection()));
        this.expectAdded(this.e3(), this.e4());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_unsupportedNonePresent() {
        try {
            this.collection.addAll(this.createDisjointCollection());
            CollectionAddAllTester.fail((String)"addAll(nonePresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.e3(), this.e4());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedSomePresent() {
        CollectionAddAllTester.assertTrue((String)"addAll(somePresent) should return true", (boolean)this.collection.addAll(MinimalCollection.of(this.e3(), this.e0())));
        CollectionAddAllTester.assertTrue((String)("should contain " + this.e3()), (boolean)this.collection.contains(this.e3()));
        CollectionAddAllTester.assertTrue((String)("should contain " + this.e0()), (boolean)this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_unsupportedSomePresent() {
        try {
            this.collection.addAll(MinimalCollection.of(this.e3(), this.e0()));
            CollectionAddAllTester.fail((String)"addAll(somePresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            CollectionAddAllTester.assertTrue((boolean)this.collection.addAll(MinimalCollection.of(this.e3(), this.e0())));
            iterator.next();
            CollectionAddAllTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_unsupportedAllPresent() {
        try {
            CollectionAddAllTester.assertFalse((String)"addAll(allPresent) should return false or throw", (boolean)this.collection.addAll(MinimalCollection.of(this.e0())));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES}, absent={CollectionFeature.RESTRICTS_ELEMENTS})
    public void testAddAll_nullSupported() {
        List<Object> containsNull = Collections.singletonList(null);
        CollectionAddAllTester.assertTrue((String)"addAll(containsNull) should return true", (boolean)this.collection.addAll(containsNull));
        this.expectAdded(new Object[]{null});
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAll_nullUnsupported() {
        List<Object> containsNull = Collections.singletonList(null);
        try {
            this.collection.addAll(containsNull);
            CollectionAddAllTester.fail((String)"addAll(containsNull) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported addAll(containsNull)");
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_nullCollectionReference() {
        try {
            this.collection.addAll(null);
            CollectionAddAllTester.fail((String)"addAll(null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddAllNullUnsupportedMethod() {
        return Helpers.getMethod(CollectionAddAllTester.class, "testAddAll_nullUnsupported");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddAllUnsupportedNonePresentMethod() {
        return Helpers.getMethod(CollectionAddAllTester.class, "testAddAll_unsupportedNonePresent");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddAllUnsupportedSomePresentMethod() {
        return Helpers.getMethod(CollectionAddAllTester.class, "testAddAll_unsupportedSomePresent");
    }
}

