/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.testing.ClusterException;
import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownAccepter;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
public class TearDownStack
implements TearDownAccepter {
    private static final Logger logger = Logger.getLogger(TearDownStack.class.getName());
    @VisibleForTesting
    final Object lock = new Object();
    @GuardedBy(value="lock")
    final LinkedList<TearDown> stack = new LinkedList();
    private final boolean suppressThrows;

    public TearDownStack() {
        this.suppressThrows = false;
    }

    public TearDownStack(boolean suppressThrows) {
        this.suppressThrows = suppressThrows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addTearDown(TearDown tearDown) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.addFirst((TearDown)Preconditions.checkNotNull((Object)tearDown));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTearDown() {
        ArrayList stackCopy;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            stackCopy = Lists.newArrayList(this.stack);
            this.stack.clear();
        }
        for (TearDown tearDown : stackCopy) {
            try {
                tearDown.tearDown();
            }
            catch (Throwable t) {
                if (this.suppressThrows) {
                    logger.log(Level.INFO, "exception thrown during tearDown", t);
                    continue;
                }
                exceptions.add(t);
            }
        }
        if (!this.suppressThrows && exceptions.size() > 0) {
            throw ClusterException.create(exceptions);
        }
    }
}

