/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import junit.framework.AssertionFailedError;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible(emulated=true)
final class ReflectionFreeAssertThrows {
    private static final ImmutableMap<Class<? extends Throwable>, Predicate<Throwable>> INSTANCE_OF = ImmutableMap.builder().put(ArithmeticException.class, e -> e instanceof ArithmeticException).put(ArrayIndexOutOfBoundsException.class, e -> e instanceof ArrayIndexOutOfBoundsException).put(ArrayStoreException.class, e -> e instanceof ArrayStoreException).put(AssertionFailedError.class, e -> e instanceof AssertionFailedError).put(CancellationException.class, e -> e instanceof CancellationException).put(ClassCastException.class, e -> e instanceof ClassCastException).put(ConcurrentModificationException.class, e -> e instanceof ConcurrentModificationException).put(ExecutionException.class, e -> e instanceof ExecutionException).put(IllegalArgumentException.class, e -> e instanceof IllegalArgumentException).put(IllegalStateException.class, e -> e instanceof IllegalStateException).put(IndexOutOfBoundsException.class, e -> e instanceof IndexOutOfBoundsException).put(NoSuchElementException.class, e -> e instanceof NoSuchElementException).put(NullPointerException.class, e -> e instanceof NullPointerException).put(NumberFormatException.class, e -> e instanceof NumberFormatException).put(RuntimeException.class, e -> e instanceof RuntimeException).put(TimeoutException.class, e -> e instanceof TimeoutException).put(UnsupportedCharsetException.class, e -> e instanceof UnsupportedCharsetException).put(UnsupportedOperationException.class, e -> e instanceof UnsupportedOperationException).put(VerifyException.class, e -> e instanceof VerifyException).putAll(PlatformSpecificExceptionBatch.PLATFORM.exceptions()).buildOrThrow();

    @CanIgnoreReturnValue
    static <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingSupplier supplier) {
        return ReflectionFreeAssertThrows.doAssertThrows(expectedThrowable, supplier, true);
    }

    @CanIgnoreReturnValue
    static <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        return ReflectionFreeAssertThrows.doAssertThrows(expectedThrowable, () -> {
            runnable.run();
            return null;
        }, false);
    }

    private static <T extends Throwable> T doAssertThrows(Class<T> expectedThrowable, ThrowingSupplier supplier, boolean userPassedSupplier) {
        Object result;
        Preconditions.checkNotNull(expectedThrowable);
        Preconditions.checkNotNull((Object)supplier);
        Predicate predicate = (Predicate)INSTANCE_OF.get(expectedThrowable);
        if (predicate == null) {
            throw new IllegalArgumentException(expectedThrowable + " is not yet supported by ReflectionFreeAssertThrows. Add an entry for it in the map in that class.");
        }
        try {
            result = supplier.get();
        }
        catch (Throwable t) {
            if (predicate.apply((Object)t)) {
                Throwable caught = t;
                return (T)caught;
            }
            throw new AssertionError("expected to throw " + expectedThrowable.getSimpleName() + " but threw " + t, t);
        }
        if (userPassedSupplier) {
            throw new AssertionError((Object)("expected to throw " + expectedThrowable.getSimpleName() + " but returned result: " + result));
        }
        throw new AssertionError((Object)("expected to throw " + expectedThrowable.getSimpleName()));
    }

    private ReflectionFreeAssertThrows() {
    }

    static interface ThrowingSupplier {
        public @Nullable Object get() throws Throwable;
    }

    static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    private static enum PlatformSpecificExceptionBatch {
        PLATFORM{

            @Override
            @GwtIncompatible
            @J2ktIncompatible
            ImmutableMap<Class<? extends Throwable>, Predicate<Throwable>> exceptions() {
                return ImmutableMap.of(InvocationTargetException.class, e -> e instanceof InvocationTargetException, StackOverflowError.class, e -> e instanceof StackOverflowError);
            }
        };


        ImmutableMap<Class<? extends Throwable>, Predicate<Throwable>> exceptions() {
            return ImmutableMap.of();
        }
    }
}

